# Workflow Setings

1. [Submission](workflow-settings#submission)
1. [Review](workflow-settings#review)
1. [Publisher Library](workflow-settings#publisher)
1. [Emails](workflow-settings#emails)

Configure all aspects of the [Editorial Workflow](../editorial-workflow), including file management, submission guidelines and requirements, peer review deadlines and guidelines, email notifications, and much more. See [Learning OJS 3 Workflow Settings](https://docs.pkp.sfu.ca/learning-ojs/en/settings-workflow) for detailed instructions.

## <a name="submission"></a>Submission
The Submission tab determines what information authors provide or agree to when they make a submission.

### Metadata
If you Enable a metadata field it will be available for each submission. Checking **Submission Form** will allow authors to add it when they make a submission. Otherwise only an editor will be able to add it.

### Components
Components are types of files that can be included with a submission.  You can add new components or edit or delete the default components. Components can be configured as supplementary or dependent, which determines how or whether they are published.

### Checklist
Provide authors with a checklist of tasks they should complete before completing their submission. This is a good place to indicate requirements for referencing, font size, line spacing, document format, and more.

### Author Guidelines
Author Guidelines will be shown to authors when they make a submission.

## <a name="review"></a>Review
Set all of your review policies and procedures, including deadlines, notifications, reviewer guidelines, and more.

### Setup
Choose the review mode that should be used by default. The mode can be changed on a per-submission and per-review basis by an editor.

- A **Double-Blind** review will prevent the reviewer and the author from knowing each other's identities
- A **Blind** review will prevent the author from knowing the reviewer's identity
- An **Open** review will allow the reviewer and author to know each other's identities

If you **Enable one-click reviewer access** the email invitation to reviewers will contain a special URL that takes invited reviewers directly to the Review page for the submission without requiring them to log in. For security reasons, with this option, editors are not able to modify email addresses or add CCs or BCCs prior to sending invitations to reviewers.

### Reviewer Guidance
Provide reviewers with criteria for judging a submission's suitability for publication in the journal, which may include instructions for preparing an effective and helpful review. Reviewers will have an opportunity to provide comments intended for the author and editor, as well as separate comments only for the editor.

### Review Forms
If you would like to request specific information from reviewers, you can build forms here. An editor will be able to select a form when assigning a reviewer, and the reviewer will be asked to complete that form when they are submitting their review.

## <a name="publisher"></a>Publisher Library
The Publisher Library provides a file repository for storing and quickly sharing common files, such as writing guidelines, author contracts and release forms, and marketing materials.

Items that are stored in the Publisher Library can be quickly retrieved and added into a [Submission Library](../editorial-workflow#submission-library) to be shared with authors or assistants.

## <a name="emails"></a>Emails
OJS sends a number of emails during various stages of the [Editorial Workflow](../editorial-workflow) as well as other actions such as registration and submission acknowledgement. The settings in this section allow you to edit the signature attached to each email as well as change the default messages sent for each type of email.

You can view a description of each email and edit the email by clicking the dropdown arrow on the right.
