<?php

/**
 * This file is based on the MaxMind's
 * "CSV file which maps FIPS 10-4 region codes to their corresponding ISO 3166-2 subdivision codes" [https://dev.maxmind.com/static/csv//fips-iso-map.csv?lang=en]
 * that is made available under the
 * Creative Commons Attribution 4.0 License [https://creativecommons.org/licenses/by/4.0/].
 * See also: https://dev.maxmind.com/geoip/whats-new-in-geoip2?lang=en
 */

return [
  'AD' => [
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
  ],
  'AE' => [
    '01' => 'AZ',
    '02' => 'AJ',
    '03' => 'DU',
    '04' => 'FU',
    '05' => 'RK',
    '06' => 'SH',
    '07' => 'UQ',
  ],
  'AF' => [
    '01' => 'BDS',
    '02' => 'BDG',
    '03' => 'BGL',
    '05' => 'BAM',
    '06' => 'FRA',
    '07' => 'FYB',
    '08' => 'GHA',
    '09' => 'GHO',
    '10' => 'HEL',
    '11' => 'HER',
    '13' => 'KAB',
    '14' => 'KAP',
    '17' => 'LOG',
    '18' => 'NAN',
    '19' => 'NIM',
    '23' => 'KAN',
    '24' => 'KDZ',
    '26' => 'TAK',
    '27' => 'WAR',
    '28' => 'ZAB',
    '29' => 'PKA',
    '30' => 'BAL',
    '31' => 'JOW',
    '32' => 'SAM',
    '33' => 'SAR',
    '34' => 'KNR',
    '35' => 'LAG',
    '36' => 'PIA',
    '37' => 'KHO',
    '38' => 'NUR',
    '39' => 'URU',
    '40' => 'PAR',
    '41' => 'DAY',
    '42' => 'PAN',
  ],
  'AG' => [
    '01' => '10',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
    '09' => '11',
  ],
  'AL' => [
    '40' => '01',
    '41' => '09',
    '42' => '02',
    '43' => '03',
    '44' => '04',
    '45' => '05',
    '46' => '06',
    '47' => '07',
    '48' => '08',
    '49' => '10',
    '50' => '11',
    '51' => '12',
    '01' => 'BR',
    '02' => 'DI',
    '03' => 'DR',
    '04' => 'EL',
    '05' => 'FR',
    '06' => 'GJ',
    '07' => 'GR',
    '08' => 'ER',
    '09' => 'KO',
    '10' => 'KR',
    '11' => 'KU',
    '12' => 'LE',
    '13' => 'LB',
    '14' => 'LU',
    '15' => 'MT',
    '16' => 'MR',
    '17' => 'PR',
    '18' => 'PG',
    '19' => 'PU',
    '20' => 'SR',
    '21' => 'SH',
    '22' => 'SK',
    '23' => 'TE',
    '26' => 'TP',
    '27' => 'VL',
    '28' => 'TR',
    '29' => 'BU',
    '30' => 'DL',
    '31' => 'DV',
    '32' => 'HA',
    '33' => 'KA',
    '34' => 'KC',
    '35' => 'KB',
    '36' => 'MM',
    '37' => 'MK',
    '38' => 'PQ',
  ],
  'AM' => [
    '01' => 'AG',
    '02' => 'AR',
    '03' => 'AV',
    '04' => 'GR',
    '05' => 'KT',
    '06' => 'LO',
    '07' => 'SH',
    '08' => 'SU',
    '09' => 'TV',
    '10' => 'VD',
    '11' => 'ER',
  ],
  'AO' => [
    '01' => 'BGU',
    '02' => 'BIE',
    '03' => 'CAB',
    '04' => 'CCU',
    '05' => 'CNO',
    '06' => 'CUS',
    '07' => 'CNN',
    '08' => 'HUA',
    '09' => 'HUI',
    '12' => 'MAL',
    '13' => 'NAM',
    '14' => 'MOX',
    '15' => 'UIG',
    '16' => 'ZAI',
    '17' => 'LNO',
    '18' => 'LSU',
    '19' => 'BGO',
    '20' => 'LUA',
  ],
  'AR' => [
    '01' => 'B',
    '02' => 'K',
    '03' => 'H',
    '04' => 'U',
    '05' => 'X',
    '06' => 'W',
    '07' => 'C',
    '08' => 'E',
    '09' => 'P',
    '10' => 'Y',
    '11' => 'L',
    '12' => 'F',
    '13' => 'M',
    '14' => 'N',
    '15' => 'Q',
    '16' => 'R',
    '17' => 'A',
    '18' => 'J',
    '19' => 'D',
    '20' => 'Z',
    '21' => 'S',
    '22' => 'G',
    '23' => 'V',
    '24' => 'T',
  ],
  'AS' => [
    '10' => 'E',
    '20' => 'M',
    '30' => 'R',
    '40' => 'S',
    '50' => 'W',
  ],
  'AT' => [
    '01' => '1',
    '02' => '2',
    '03' => '3',
    '04' => '4',
    '05' => '5',
    '06' => '6',
    '07' => '7',
    '08' => '8',
    '09' => '9',
  ],
  'AU' => [
    '01' => 'ACT',
    '02' => 'NSW',
    '03' => 'NT',
    '04' => 'QLD',
    '05' => 'SA',
    '06' => 'TAS',
    '07' => 'VIC',
    '08' => 'WA',
  ],
  'AZ' => [
    '01' => 'ABS',
    '02' => 'AGC',
    '03' => 'AGM',
    '04' => 'AGS',
    '05' => 'AGA',
    '06' => 'AGU',
    '07' => 'SR',
    '08' => 'AST',
    '09' => 'BA',
    '10' => 'BAL',
    '11' => 'BAR',
    '12' => 'BEY',
    '13' => 'BIL',
    '14' => 'CAB',
    '15' => 'CAL',
    '16' => 'DAS',
    '17' => 'SBN',
    '18' => 'FUZ',
    '19' => 'GAD',
    '20' => 'GA',
    '21' => 'GOR',
    '22' => 'GOY',
    '23' => 'HAC',
    '24' => 'IMI',
    '25' => 'ISM',
    '26' => 'KAL',
    '27' => 'KUR',
    '28' => 'LAC',
    '29' => 'LAN',
    '30' => 'LA',
    '31' => 'LER',
    '32' => 'MAS',
    '33' => 'MI',
    '34' => 'NA',
    '35' => 'NX',
    '36' => 'NEF',
    '37' => 'OGU',
    '38' => 'QAB',
    '39' => 'QAX',
    '40' => 'QAZ',
    '41' => 'QOB',
    '42' => 'QBA',
    '43' => 'QBI',
    '44' => 'QUS',
    '45' => 'SAT',
    '46' => 'SAB',
    '47' => 'SAK',
    '48' => 'SA',
    '49' => 'SAL',
    '50' => 'SMI',
    '51' => 'SKR',
    '52' => 'SMX',
    '53' => 'SIY',
    '54' => 'SM',
    '55' => 'SUS',
    '57' => 'TAR',
    '58' => 'TOV',
    '59' => 'UCA',
    '60' => 'XAC',
    '61' => 'XA',
    '62' => 'GYG',
    '63' => 'XIZ',
    '64' => 'XCI',
    '65' => 'XVD',
    '66' => 'YAR',
    '67' => 'YEV',
    '68' => 'YE',
    '69' => 'ZAN',
    '70' => 'ZAQ',
    '71' => 'ZAR',
    '78' => 'SAH',
    '76' => 'ORD',
    '79' => 'SAR',
    '73' => 'CUL',
    '77' => 'SAD',
    '75' => 'NV',
    '72' => 'BAB',
    '74' => 'KAN',
  ],
  'BA' => [
    '01' => 'BIH',
    '02' => 'SRP',
    '03' => 'BRC',
  ],
  'BB' => [
    '01' => '01',
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
    '09' => '09',
    '10' => '10',
    '11' => '11',
  ],
  'BD' => [
    '81' => 'C',
    '82' => 'D',
    '83' => 'E',
    '84' => 'B',
    '85' => 'A',
    '86' => 'G',
    '87' => 'F',
    '88' => 'H',
  ],
  'BE' => [
    '11' => 'BRU',
    '13' => 'VLG',
    '14' => 'WAL',
    '01' => 'VAN',
    '12' => 'VBR',
    '05' => 'VLI',
    '08' => 'VOV',
    '09' => 'VWV',
    '10' => 'WBR',
    '03' => 'WHT',
    '04' => 'WLG',
    '06' => 'WLX',
    '07' => 'WNA',
  ],
  'BF' => [
    '79' => '01',
    '80' => '02',
    '81' => '03',
    '82' => '04',
    '83' => '05',
    '84' => '06',
    '85' => '07',
    '86' => '08',
    '87' => '09',
    '88' => '10',
    '89' => '11',
    '90' => '12',
    '91' => '13',
    '15' => 'BAM',
    '19' => 'BLK',
    '20' => 'GAN',
    '21' => 'GNA',
    '28' => 'KOT',
    '33' => 'OUD',
    '34' => 'PAS',
    '36' => 'SNG',
    '40' => 'SOM',
    '42' => 'TAP',
    '44' => 'ZOU',
    '45' => 'BAL',
    '46' => 'BAN',
    '47' => 'BAZ',
    '48' => 'BGR',
    '49' => 'BLG',
    '50' => 'GOU',
    '51' => 'HOU',
    '52' => 'IOB',
    '53' => 'KAD',
    '54' => 'KEN',
    '55' => 'COM',
    '56' => 'KMD',
    '57' => 'KMP',
    '58' => 'KOS',
    '59' => 'KOP',
    '60' => 'KOW',
    '61' => 'LER',
    '62' => 'LOR',
    '63' => 'MOU',
    '64' => 'NAM',
    '65' => 'NAO',
    '66' => 'NAY',
    '67' => 'NOU',
    '68' => 'OUB',
    '69' => 'PON',
    '70' => 'SMT',
    '71' => 'SEN',
    '72' => 'SIS',
    '73' => 'SOR',
    '74' => 'TUI',
    '75' => 'YAG',
    '76' => 'YAT',
    '77' => 'ZIR',
    '78' => 'ZON',
  ],
  'BG' => [
    '38' => '01',
    '39' => '02',
    '40' => '08',
    '41' => '07',
    '42' => '22',
    '43' => '26',
    '44' => '09',
    '45' => '10',
    '46' => '11',
    '47' => '12',
    '48' => '13',
    '49' => '14',
    '50' => '15',
    '51' => '16',
    '52' => '17',
    '53' => '18',
    '54' => '27',
    '55' => '19',
    '56' => '20',
    '57' => '21',
    '58' => '23',
    '59' => '24',
    '60' => '25',
    '61' => '03',
    '62' => '04',
    '63' => '05',
    '64' => '06',
    '65' => '28',
  ],
  'BH' => [
    '15' => '15',
    '16' => '13',
    '17' => '14',
    '18' => '16',
    '19' => '17',
  ],
  'BI' => [
    '09' => 'BB',
    '10' => 'BR',
    '11' => 'CA',
    '12' => 'CI',
    '13' => 'GI',
    '14' => 'KR',
    '15' => 'KY',
    '16' => 'KI',
    '17' => 'MA',
    '18' => 'MY',
    '19' => 'NG',
    '20' => 'RT',
    '21' => 'RY',
    '22' => 'MU',
    '23' => 'MW',
    '24' => 'BM',
    '25' => 'BL',
    '26' => 'RM',
  ],
  'BJ' => [
    '07' => 'AL',
    '08' => 'AK',
    '09' => 'AQ',
    '10' => 'BO',
    '11' => 'CO',
    '12' => 'KO',
    '13' => 'DO',
    '14' => 'LI',
    '15' => 'MO',
    '16' => 'OU',
    '17' => 'PL',
    '18' => 'ZO',
  ],
  'BM' => [
    '01' => 'DS',
    '02' => 'HA',
    '03' => 'HC',
    '04' => 'PG',
    '05' => 'PB',
    '06' => 'GC',
    '07' => 'SG',
    '08' => 'SA',
    '09' => 'SM',
    '10' => 'SH',
    '11' => 'WA',
  ],
  'BN' => [
    '01' => 'BE',
    '02' => 'BM',
    '03' => 'TE',
    '04' => 'TU',
  ],
  'BO' => [
    '01' => 'H',
    '02' => 'C',
    '03' => 'B',
    '04' => 'L',
    '05' => 'O',
    '06' => 'N',
    '07' => 'P',
    '08' => 'S',
    '09' => 'T',
  ],
  'BR' => [
    '01' => 'AC',
    '02' => 'AL',
    '03' => 'AP',
    '04' => 'AM',
    '05' => 'BA',
    '06' => 'CE',
    '07' => 'DF',
    '08' => 'ES',
    '11' => 'MS',
    '13' => 'MA',
    '14' => 'MT',
    '15' => 'MG',
    '16' => 'PA',
    '17' => 'PB',
    '18' => 'PR',
    '20' => 'PI',
    '21' => 'RJ',
    '22' => 'RN',
    '23' => 'RS',
    '24' => 'RO',
    '25' => 'RR',
    '26' => 'SC',
    '27' => 'SP',
    '28' => 'SE',
    '29' => 'GO',
    '30' => 'PE',
    '31' => 'TO',
  ],
  'BS' => [
    '05' => 'BI',
    '06' => 'CI',
    '10' => 'EX',
    '13' => 'IN',
    '15' => 'LI',
    '16' => 'MG',
    '18' => 'RI',
    '22' => 'HI',
    '23' => 'NP',
    '24' => 'AK',
    '25' => 'FP',
    '26' => 'FC',
    '27' => 'CO',
    '28' => 'GT',
    '29' => 'HR',
    '30' => 'KE',
    '31' => 'MH',
    '32' => 'BY',
    '33' => 'RS',
    '34' => 'SP',
    '35' => 'SS',
    '36' => 'BP',
    '37' => 'CO',
    '38' => 'CS',
    '39' => 'CE',
    '40' => 'CK',
    '41' => 'EG',
    '42' => 'GC',
    '43' => 'HT',
    '44' => 'MC',
    '45' => 'MI',
    '46' => 'NO',
    '47' => 'NS',
    '48' => 'NE',
    '49' => 'RC',
    '50' => 'SO',
    '51' => 'SA',
    '52' => 'SE',
    '53' => 'SW',
    '54' => 'WG',
  ],
  'BT' => [
    '05' => '33',
    '06' => '12',
    '07' => '21',
    '08' => '22',
    '09' => '31',
    '10' => '13',
    '11' => '44',
    '12' => '42',
    '13' => '11',
    '14' => '43',
    '15' => '23',
    '16' => '14',
    '17' => '45',
    '18' => '34',
    '19' => '41',
    '20' => '15',
    '21' => '32',
    '22' => '24',
    '23' => 'GA',
    '24' => 'TY',
  ],
  'BW' => [
    '01' => 'CE',
    '03' => 'GH',
    '04' => 'KG',
    '05' => 'KL',
    '06' => 'KW',
    '08' => 'NE',
    '09' => 'SE',
    '10' => 'SO',
    '11' => 'NW',
    '12' => 'CH',
    '13' => 'FR',
    '14' => 'GA',
    '15' => 'JW',
    '16' => 'LO',
    '17' => 'SP',
    '18' => 'ST',
  ],
  'BY' => [
    '01' => 'BR',
    '02' => 'HO',
    '03' => 'HR',
    '04' => 'HM',
    '05' => 'MI',
    '06' => 'MA',
    '07' => 'VI',
  ],
  'BZ' => [
    '01' => 'BZ',
    '02' => 'CY',
    '03' => 'CZL',
    '04' => 'OW',
    '05' => 'SC',
    '06' => 'TOL',
  ],
  'CD' => [
    '01' => 'BN',
    '02' => 'EQ',
    '03' => 'KW',
    '04' => 'KE',
    '05' => 'KA',
    '06' => 'KN',
    '08' => 'BC',
    '09' => 'OR',
    '10' => 'MA',
    '11' => 'NK',
    '12' => 'SK',
    '13' => 'BU',
    '14' => 'HK',
    '15' => 'HL',
    '16' => 'HU',
    '17' => 'IT',
    '18' => 'KS',
    '19' => 'KG',
    '20' => 'KL',
    '21' => 'LO',
    '22' => 'LU',
    '23' => 'KC',
    '24' => 'MN',
    '25' => 'MO',
    '26' => 'NU',
    '27' => 'SA',
    '28' => 'SU',
    '29' => 'TA',
    '30' => 'TO',
    '31' => 'TU',
  ],
  'CF' => [
    '01' => 'BB',
    '02' => 'BK',
    '03' => 'HK',
    '04' => 'HS',
    '05' => 'HM',
    '06' => 'KG',
    '07' => 'LB',
    '08' => 'MB',
    '09' => 'NM',
    '11' => 'UK',
    '12' => 'AC',
    '13' => 'OP',
    '14' => 'VK',
    '15' => 'KB',
    '16' => 'SE',
    '17' => 'MP',
    '18' => 'BGF',
  ],
  'CG' => [
    '01' => '11',
    '04' => '5',
    '05' => '2',
    '06' => '7',
    '07' => '9',
    '08' => '14',
    '10' => '13',
    '11' => '12',
    '12' => 'BZV',
    '13' => '8',
    '14' => '15',
    '15' => '16',
  ],
  'CH' => [
    '01' => 'AG',
    '10' => 'AI',
    '02' => 'AR',
    '05' => 'BE',
    '03' => 'BL',
    '04' => 'BS',
    '06' => 'FR',
    '07' => 'GE',
    '08' => 'GL',
    '09' => 'GR',
    '26' => 'JU',
    '11' => 'LU',
    '12' => 'NE',
    '13' => 'NW',
    '14' => 'OW',
    '15' => 'SG',
    '16' => 'SH',
    '18' => 'SO',
    '17' => 'SZ',
    '19' => 'TG',
    '20' => 'TI',
    '21' => 'UR',
    '23' => 'VD',
    '22' => 'VS',
    '24' => 'ZG',
    '25' => 'ZH',
  ],
  'CI' => [
    '74' => '16',
    '75' => '17',
    '76' => 'BS',
    '77' => 'DN',
    '78' => 'MG',
    '79' => '18',
    '80' => '02',
    '81' => 'LC',
    '82' => 'LG',
    '83' => '12',
    '84' => '19',
    '85' => '05',
    '86' => '11',
    '87' => 'SV',
    '88' => '15',
    '89' => '13',
    '90' => 'VB',
    '91' => '14',
    '92' => 'ZZ',
    '93' => 'AB',
    '94' => 'CM',
    '95' => 'GD',
    '96' => 'SM',
    '97' => 'WR',
    '98' => 'YM',
  ],
  'CL' => [
    '01' => 'VS',
    '02' => 'AI',
    '03' => 'AN',
    '04' => 'AR',
    '05' => 'AT',
    '06' => 'BI',
    '07' => 'CO',
    '08' => 'LI',
    '10' => 'MA',
    '11' => 'ML',
    '12' => 'RM',
    '14' => 'LL',
    '15' => 'TA',
    '16' => 'AP',
    '17' => 'LR',
    '18' => 'NB',
  ],
  'CM' => [
    '04' => 'ES',
    '05' => 'LT',
    '07' => 'NW',
    '08' => 'OU',
    '09' => 'SW',
    '10' => 'AD',
    '11' => 'CE',
    '12' => 'EN',
    '13' => 'NO',
    '14' => 'SU',
  ],
  'CN' => [
    '01' => 'AH',
    '02' => 'ZJ',
    '03' => 'JX',
    '04' => 'JS',
    '05' => 'JL',
    '06' => 'QH',
    '07' => 'FJ',
    '08' => 'HL',
    '09' => 'HA',
    '10' => 'HE',
    '11' => 'HN',
    '12' => 'HB',
    '13' => 'XJ',
    '14' => 'XZ',
    '15' => 'GS',
    '16' => 'GX',
    '18' => 'GZ',
    '19' => 'LN',
    '20' => 'NM',
    '21' => 'NX',
    '22' => 'BJ',
    '23' => 'SH',
    '24' => 'SX',
    '25' => 'SD',
    '26' => 'SN',
    '28' => 'TJ',
    '29' => 'YN',
    '30' => 'GD',
    '31' => 'HI',
    '32' => 'SC',
    '33' => 'CQ',
  ],
  'CO' => [
    '01' => 'AMA',
    '02' => 'ANT',
    '03' => 'ARA',
    '04' => 'ATL',
    '08' => 'CAQ',
    '09' => 'CAU',
    '10' => 'CES',
    '11' => 'CHO',
    '12' => 'COR',
    '14' => 'GUV',
    '15' => 'GUA',
    '16' => 'HUI',
    '17' => 'LAG',
    '19' => 'MET',
    '20' => 'NAR',
    '21' => 'NSA',
    '22' => 'PUT',
    '23' => 'QUI',
    '24' => 'RIS',
    '25' => 'SAP',
    '26' => 'SAN',
    '27' => 'SUC',
    '28' => 'TOL',
    '29' => 'VAC',
    '30' => 'VAU',
    '31' => 'VID',
    '32' => 'CAS',
    '33' => 'CUN',
    '34' => 'DC',
    '35' => 'BOL',
    '36' => 'BOY',
    '37' => 'CAL',
    '38' => 'MAG',
  ],
  'CR' => [
    '01' => 'A',
    '02' => 'C',
    '03' => 'G',
    '04' => 'H',
    '06' => 'L',
    '07' => 'P',
    '08' => 'SJ',
  ],
  'CU' => [
    '01' => '01',
    '02' => '03',
    '03' => '04',
    '04' => '99',
    '05' => '09',
    '07' => '08',
    '08' => '06',
    '09' => '12',
    '10' => '14',
    '11' => '02',
    '12' => '11',
    '13' => '10',
    '14' => '07',
    '15' => '13',
    '16' => '05',
    '17' => '15',
    '18' => '16',
  ],
  'CV' => [
    '01' => 'BV',
    '02' => 'BR',
    '04' => 'MA',
    '05' => 'PA',
    '07' => 'RG',
    '08' => 'SL',
    '11' => 'SV',
    '13' => 'MO',
    '14' => 'PR',
    '15' => 'CA',
    '16' => 'CR',
    '17' => 'SD',
    '18' => 'SF',
    '19' => 'SM',
    '20' => 'TA',
    '21' => 'PN',
    '22' => 'RB',
    '23' => 'RS',
    '24' => 'CF',
    '25' => 'SO',
    '26' => 'SS',
    '27' => 'TS',
  ],
  'CY' => [
    '01' => '04',
    '02' => '06',
    '03' => '03',
    '04' => '01',
    '05' => '02',
    '06' => '05',
  ],
  'CZ' => [
    '52' => '10',
    '78' => '64',
    '79' => '31',
    '80' => '63',
    '81' => '41',
    '82' => '52',
    '83' => '51',
    '84' => '71',
    '85' => '80',
    '86' => '53',
    '87' => '32',
    '88' => '20',
    '89' => '42',
    '90' => '72',
  ],
  'DE' => [
    '01' => 'BW',
    '02' => 'BY',
    '03' => 'HB',
    '04' => 'HH',
    '05' => 'HE',
    '06' => 'NI',
    '07' => 'NW',
    '08' => 'RP',
    '09' => 'SL',
    '10' => 'SH',
    '11' => 'BB',
    '12' => 'MV',
    '13' => 'SN',
    '14' => 'ST',
    '15' => 'TH',
    '16' => 'BE',
  ],
  'DJ' => [
    '01' => 'AS',
    '04' => 'OB',
    '05' => 'TA',
    '06' => 'DI',
    '07' => 'DJ',
    '08' => 'AR',
  ],
  'DK' => [
    '17' => '84',
    '18' => '82',
    '19' => '81',
    '20' => '85',
    '21' => '83',
  ],
  'DM' => [
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
    '09' => '09',
    '10' => '10',
    '11' => '11',
  ],
  'DO' => [
    '01' => '02',
    '02' => '03',
    '03' => '04',
    '04' => '05',
    '06' => '06',
    '08' => '09',
    '09' => '10',
    '10' => '11',
    '11' => '07',
    '12' => '12',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '18' => '18',
    '19' => '19',
    '20' => '20',
    '21' => '24',
    '23' => '22',
    '24' => '23',
    '25' => '25',
    '26' => '26',
    '27' => '27',
    '28' => '08',
    '29' => '30',
    '30' => '13',
    '31' => '28',
    '32' => '29',
    '33' => '21',
    '34' => '01',
    '35' => '17',
    '36' => '31',
    '37' => '32',
  ],
  'DZ' => [
    '01' => '16',
    '03' => '05',
    '04' => '25',
    '06' => '26',
    '07' => '27',
    '09' => '31',
    '10' => '20',
    '12' => '19',
    '13' => '14',
    '14' => '15',
    '15' => '13',
    '18' => '06',
    '19' => '07',
    '20' => '09',
    '21' => '10',
    '22' => '17',
    '23' => '24',
    '24' => '18',
    '25' => '03',
    '26' => '29',
    '27' => '28',
    '29' => '04',
    '30' => '22',
    '31' => '21',
    '33' => '12',
    '34' => '01',
    '35' => '44',
    '36' => '46',
    '37' => '23',
    '38' => '08',
    '39' => '34',
    '40' => '35',
    '41' => '02',
    '42' => '32',
    '43' => '39',
    '44' => '36',
    '45' => '47',
    '46' => '33',
    '47' => '40',
    '48' => '43',
    '49' => '45',
    '50' => '30',
    '51' => '48',
    '52' => '41',
    '53' => '11',
    '54' => '37',
    '55' => '42',
    '56' => '38',
  ],
  'EC' => [
    '01' => 'W',
    '02' => 'A',
    '03' => 'B',
    '04' => 'F',
    '05' => 'C',
    '06' => 'H',
    '07' => 'X',
    '08' => 'O',
    '09' => 'E',
    '10' => 'G',
    '11' => 'I',
    '12' => 'L',
    '13' => 'R',
    '14' => 'M',
    '15' => 'S',
    '17' => 'Y',
    '18' => 'P',
    '19' => 'T',
    '20' => 'Z',
    '22' => 'U',
    '23' => 'N',
    '24' => 'D',
    '25' => 'SE',
    '26' => 'SD',
  ],
  'EE' => [
    '01' => '37',
    '02' => '39',
    '03' => '44',
    '04' => '51',
    '05' => '49',
    '07' => '57',
    '08' => '59',
    '11' => '67',
    '12' => '65',
    '13' => '70',
    '14' => '74',
    '18' => '78',
    '19' => '82',
    '20' => '84',
    '21' => '86',
  ],
  'EG' => [
    '01' => 'DK',
    '02' => 'BA',
    '03' => 'BH',
    '04' => 'FYM',
    '05' => 'GH',
    '06' => 'ALX',
    '07' => 'IS',
    '08' => 'GZ',
    '09' => 'MNF',
    '10' => 'MN',
    '11' => 'C',
    '12' => 'KB',
    '13' => 'WAD',
    '14' => 'SHR',
    '15' => 'SUZ',
    '16' => 'ASN',
    '17' => 'AST',
    '18' => 'BNS',
    '19' => 'PTS',
    '20' => 'DT',
    '21' => 'KFS',
    '22' => 'MT',
    '23' => 'KN',
    '24' => 'SHG',
    '26' => 'JS',
    '27' => 'SIN',
    '28' => 'LX',
    '29' => 'SU',
    '30' => 'HU',
  ],
  'ER' => [
    '01' => 'AN',
    '02' => 'DU',
    '03' => 'DK',
    '04' => 'GB',
    '05' => 'MA',
    '06' => 'SK',
  ],
  'ES' => [
    '07' => 'IB',
    '27' => 'RI',
    '29' => 'MD',
    '31' => 'MC',
    '32' => 'NC',
    '34' => 'AS',
    '39' => 'CB',
    '51' => 'AN',
    '52' => 'AR',
    '53' => 'CN',
    '54' => 'CM',
    '55' => 'CL',
    '56' => 'CT',
    '57' => 'EX',
    '58' => 'GA',
    '59' => 'PV',
    '60' => 'VC',
    '61' => 'CE',
    '62' => 'ML',
  ],
  'ET' => [
    '44' => 'AA',
    '45' => 'AF',
    '46' => 'AM',
    '47' => 'BE',
    '48' => 'DD',
    '49' => 'GA',
    '50' => 'HA',
    '51' => 'OR',
    '52' => 'SO',
    '53' => 'TI',
    '54' => 'SN',
  ],
  'FI' => [
    '16' => '01',
    '01' => 'AL',
    '35' => '18',
    '34' => '19',
    '32' => '17',
    '20' => '06',
    '06' => 'LL',
    '28' => '11',
    '27' => '16',
    '25' => '09',
    '08' => 'OL',
    '17' => '02',
    '19' => '04',
    '33' => '15',
    '30' => '13',
    '24' => '08',
    '13' => 'ES',
    '14' => 'IS',
    '18' => '03',
    '15' => 'LS',
    '29' => '12',
    '23' => '07',
    '31' => '14',
    '22' => '05',
    '26' => '10',
  ],
  'FJ' => [
    '01' => 'C',
    '02' => 'E',
    '03' => 'N',
    '04' => 'R',
    '05' => 'W',
    '06' => '01',
    '07' => '02',
    '08' => '03',
    '09' => '04',
    '10' => '05',
    '11' => '06',
    '12' => '07',
    '13' => '08',
    '14' => '09',
    '15' => '10',
    '16' => '11',
    '17' => '12',
    '18' => '13',
    '19' => '14',
  ],
  'FM' => [
    '01' => 'KSA',
    '02' => 'PNI',
    '03' => 'TRK',
    '04' => 'YAP',
  ],
  'FR' => [
    'A8' => 'IDF',
    'A3' => 'CVL',
    'C3' => 'BFC',
    'C6' => 'NOR',
    'C5' => 'HDF',
    'C4' => 'GES',
    'B5' => 'PDL',
    'A2' => 'BRE',
    'C7' => 'NAQ',
    'C8' => 'OCC',
    'C2' => 'ARA',
    'B8' => 'PAC',
    'A5' => 'COR',
    '97' => 'B',
    '98' => 'C',
    '99' => 'P',
    'A1' => 'D',
    'A4' => 'G',
    'A6' => 'I',
    'A7' => 'Q',
    'A9' => 'K',
    'B1' => 'L',
    'B2' => 'M',
    'B3' => 'N',
    'B4' => 'O',
    'B6' => 'S',
    'B7' => 'T',
    'B9' => 'V',
    'C1' => 'A',
  ],
  'GA' => [
    '01' => '1',
    '02' => '2',
    '03' => '3',
    '04' => '4',
    '05' => '5',
    '06' => '6',
    '07' => '7',
    '08' => '8',
    '09' => '9',
  ],
  'GB' => [
    'A1' => 'BDG',
    'A2' => 'BNE',
    'A3' => 'BNS',
    'A4' => 'BAS',
    'A5' => 'BDF',
    'A6' => 'BEX',
    'A7' => 'BIR',
    'A8' => 'BBD',
    'A9' => 'BPL',
    'B1' => 'BOL',
    'B2' => 'BMH',
    'B3' => 'BRC',
    'B4' => 'BRD',
    'B5' => 'BEN',
    'B6' => 'BNH',
    'B7' => 'BST',
    'B8' => 'BRY',
    'B9' => 'BKM',
    'C1' => 'BUR',
    'C2' => 'CLD',
    'C3' => 'CAM',
    'C4' => 'CMD',
    'C5' => 'CHS',
    'C6' => 'CON',
    'C7' => 'COV',
    'C8' => 'CRY',
    'C9' => 'CMA',
    'D1' => 'DAL',
    'D2' => 'DER',
    'D3' => 'DBY',
    'D4' => 'DEV',
    'D5' => 'DNC',
    'D6' => 'DOR',
    'D7' => 'DUD',
    'D8' => 'DUR',
    'D9' => 'EAL',
    'E1' => 'ERY',
    'E2' => 'ESX',
    'E3' => 'ENF',
    'E4' => 'ESS',
    'E5' => 'GAT',
    'E6' => 'GLS',
    'E7' => 'GRE',
    'E8' => 'HCK',
    'E9' => 'HAL',
    'F1' => 'HMF',
    'F2' => 'HAM',
    'F3' => 'HRY',
    'F4' => 'HRW',
    'F5' => 'HPL',
    'F6' => 'HAV',
    'F7' => 'HEF',
    'F8' => 'HRT',
    'F9' => 'HIL',
    'G1' => 'HNS',
    'G2' => 'IOW',
    'G3' => 'ISL',
    'G4' => 'KEC',
    'G5' => 'KEN',
    'G6' => 'KHL',
    'G7' => 'KTT',
    'G8' => 'KIR',
    'G9' => 'KWL',
    'H1' => 'LBH',
    'H2' => 'LAN',
    'H3' => 'LDS',
    'H4' => 'LCE',
    'H5' => 'LEC',
    'H6' => 'LEW',
    'H7' => 'LIN',
    'H8' => 'LIV',
    'H9' => 'LND',
    'I1' => 'LUT',
    'I2' => 'MAN',
    'I3' => 'MDW',
    'I4' => 'MRT',
    'I5' => 'MDB',
    'I6' => 'MIK',
    'I7' => 'NET',
    'I8' => 'NWM',
    'I9' => 'NFK',
    'J1' => 'NTH',
    'J2' => 'NEL',
    'J3' => 'NLN',
    'J4' => 'NSM',
    'J5' => 'NTY',
    'J6' => 'NBL',
    'J7' => 'NYK',
    'J8' => 'NGM',
    'J9' => 'NTT',
    'K1' => 'OLD',
    'K2' => 'OXF',
    'K3' => 'PTE',
    'K4' => 'PLY',
    'K5' => 'POL',
    'K6' => 'POR',
    'K7' => 'RDG',
    'K8' => 'RDB',
    'K9' => 'RCC',
    'L1' => 'RIC',
    'L2' => 'RCH',
    'L3' => 'ROT',
    'L4' => 'RUT',
    'L5' => 'SLF',
    'L6' => 'SHR',
    'L7' => 'SAW',
    'L8' => 'SFT',
    'L9' => 'SHF',
    'M1' => 'SLG',
    'M2' => 'SOL',
    'M3' => 'SOM',
    'M4' => 'STH',
    'M5' => 'SOS',
    'M6' => 'SGC',
    'M7' => 'STY',
    'M8' => 'SWK',
    'M9' => 'STS',
    '1A' => 'ANN',
    '3A' => 'ABC',
    'R3' => 'BFS',
    '4A' => 'CCG',
    '5A' => 'DRS',
    '6A' => 'FMO',
    '7A' => 'LBC',
    '8A' => 'MEA',
    '9A' => 'MUL',
    '1B' => 'NMD',
    '2A' => 'AND',
    'N1' => 'SHN',
    'N2' => 'SKP',
    'N3' => 'STT',
    'N4' => 'STE',
    'N5' => 'SFK',
    'N6' => 'SND',
    'N7' => 'SRY',
    'N8' => 'STN',
    'N9' => 'SWD',
    'O1' => 'TAM',
    'O2' => 'TFW',
    'O3' => 'THR',
    'O4' => 'TOB',
    'O5' => 'TWH',
    'O6' => 'TRF',
    'O7' => 'WKF',
    'O8' => 'WLL',
    'O9' => 'WFT',
    'P1' => 'WND',
    'P2' => 'WRT',
    'P3' => 'WAR',
    'P4' => 'WBK',
    'P5' => 'WSM',
    'P6' => 'WSX',
    'P7' => 'WGN',
    'P8' => 'WIL',
    'P9' => 'WNM',
    'Q1' => 'WRL',
    'Q2' => 'WOK',
    'Q3' => 'WLV',
    'Q4' => 'WOR',
    'Q5' => 'YOR',
    'Q6' => 'ANT',
    'Q7' => 'ARD',
    'Q8' => 'ARM',
    'Q9' => 'BLA',
    'R1' => 'BLY',
    'R2' => 'BNB',
    'R4' => 'CKF',
    'R5' => 'CSR',
    'R6' => 'CLR',
    'R7' => 'CKT',
    'R8' => 'CGV',
    'R9' => 'DOW',
    'S1' => 'DGN',
    'S2' => 'FER',
    'S3' => 'LRN',
    'S4' => 'LMV',
    'S5' => 'LSB',
    'S6' => 'DRY',
    'S7' => 'MFT',
    'S8' => 'MYL',
    'S9' => 'NYM',
    'T1' => 'NTA',
    'T2' => 'NDN',
    'T3' => 'OMH',
    'T4' => 'STB',
    'T5' => 'ABE',
    'T6' => 'ABD',
    'T7' => 'ANS',
    'T8' => 'AGB',
    'T9' => 'SCB',
    'U1' => 'CLK',
    'U2' => 'DGY',
    'U3' => 'DND',
    'U4' => 'EAY',
    'U5' => 'EDU',
    'U6' => 'ELN',
    'U7' => 'ERW',
    'U8' => 'EDH',
    'U9' => 'FAL',
    'V1' => 'FIF',
    'V2' => 'GLG',
    'V3' => 'HLD',
    'V4' => 'IVC',
    'V5' => 'MLN',
    'V6' => 'MRY',
    'V7' => 'NAY',
    'V8' => 'NLK',
    'V9' => 'ORK',
    'W1' => 'PKN',
    'W2' => 'RFW',
    'W3' => 'ZET',
    'W4' => 'SAY',
    'W5' => 'SLK',
    'W6' => 'STG',
    'W7' => 'WDU',
    'W8' => 'ELS',
    'W9' => 'WLN',
    'X1' => 'AGY',
    'X2' => 'BGW',
    'X3' => 'BGE',
    'X4' => 'CAY',
    'X5' => 'CRF',
    'X6' => 'CGN',
    'X7' => 'CMN',
    'X8' => 'CWY',
    'X9' => 'DEN',
    'Y1' => 'FLN',
    'Y2' => 'GWN',
    'Y3' => 'MTY',
    'Y4' => 'MON',
    'Y5' => 'NTL',
    'Y6' => 'NWP',
    'Y7' => 'PEM',
    'Y8' => 'POW',
    'Y9' => 'RCT',
    'Z1' => 'SWA',
    'Z2' => 'TOF',
    'Z3' => 'VGL',
    'Z4' => 'WRX',
    'Z5' => 'BDF',
    'Z6' => 'CBF',
    'Z7' => 'CHE',
    'Z8' => 'CHW',
    'Z9' => 'IOS',
  ],
  'GD' => [
    '01' => '01',
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
  ],
  'GE' => [
    '02' => 'AB',
    '04' => 'AJ',
    '51' => 'TB',
    '65' => 'GU',
    '66' => 'IM',
    '67' => 'KA',
    '68' => 'KK',
    '69' => 'MM',
    '70' => 'RL',
    '71' => 'SZ',
    '72' => 'SJ',
    '73' => 'SK',
  ],
  'GH' => [
    '01' => 'AA',
    '02' => 'AH',
    '03' => 'BA',
    '04' => 'CP',
    '05' => 'EP',
    '06' => 'NP',
    '08' => 'TV',
    '09' => 'WP',
    '10' => 'UE',
    '11' => 'UW',
    '12' => 'AF',
    '13' => 'BO',
    '14' => 'BE',
    '15' => 'NE',
    '16' => 'OT',
    '17' => 'SV',
    '18' => 'WN',
  ],
  'GL' => [
    '04' => 'KU',
    '05' => 'QA',
    '06' => 'QE',
    '07' => 'SM',
    '09' => 'QT',
    '08' => 'AV',
  ],
  'GM' => [
    '01' => 'B',
    '02' => 'L',
    '03' => 'M',
    '04' => 'U',
    '05' => 'W',
    '07' => 'N',
  ],
  'GN' => [
    '04' => 'C',
    '40' => 'B',
    '43' => 'D',
    '41' => 'F',
    '42' => 'K',
    '44' => 'L',
    '45' => 'M',
    '46' => 'N',
    '01' => 'BE',
    '02' => 'BF',
    '03' => 'BK',
    '05' => 'DB',
    '06' => 'DL',
    '07' => 'DI',
    '09' => 'FA',
    '10' => 'FO',
    '11' => 'FR',
    '12' => 'GA',
    '13' => 'GU',
    '15' => 'KE',
    '16' => 'KD',
    '17' => 'KS',
    '18' => 'KN',
    '19' => 'KO',
    '21' => 'MC',
    '22' => 'ML',
    '23' => 'MM',
    '25' => 'PI',
    '27' => 'TE',
    '28' => 'TO',
    '29' => 'YO',
    '30' => 'CO',
    '31' => 'DU',
    '32' => 'KA',
    '33' => 'KB',
    '34' => 'LA',
    '35' => 'LE',
    '36' => 'LO',
    '37' => 'MD',
    '38' => 'NZ',
    '39' => 'SI',
  ],
  'GQ' => [
    '03' => 'AN',
    '04' => 'BN',
    '05' => 'BS',
    '06' => 'CS',
    '07' => 'KN',
    '08' => 'LI',
    '09' => 'WN',
  ],
  'GR' => [
    '52' => '69',
    '53' => 'A',
    '59' => 'B',
    '56' => 'C',
    '64' => 'E',
    '58' => 'D',
    '57' => 'F',
    '55' => 'G',
    '63' => 'H',
    '62' => 'J',
    '54' => 'I',
    '65' => 'K',
    '61' => 'L',
    '60' => 'M',
  ],
  'GT' => [
    '01' => 'AV',
    '02' => 'BV',
    '03' => 'CM',
    '04' => 'CQ',
    '05' => 'PR',
    '06' => 'ES',
    '07' => 'GU',
    '08' => 'HU',
    '09' => 'IZ',
    '10' => 'JA',
    '11' => 'JU',
    '12' => 'PE',
    '13' => 'QZ',
    '14' => 'QC',
    '15' => 'RE',
    '16' => 'SA',
    '17' => 'SM',
    '18' => 'SR',
    '19' => 'SO',
    '20' => 'SU',
    '21' => 'TO',
    '22' => 'ZA',
  ],
  'GW' => [
    '01' => 'BA',
    '02' => 'QU',
    '04' => 'OI',
    '05' => 'BL',
    '06' => 'CA',
    '07' => 'TO',
    '10' => 'GA',
    '11' => 'BS',
    '12' => 'BM',
  ],
  'GY' => [
    '10' => 'BA',
    '11' => 'CU',
    '12' => 'DE',
    '13' => 'EB',
    '14' => 'ES',
    '15' => 'MA',
    '16' => 'PM',
    '17' => 'PT',
    '18' => 'UD',
    '19' => 'UT',
  ],
  'HN' => [
    '01' => 'AT',
    '02' => 'CH',
    '03' => 'CL',
    '04' => 'CM',
    '05' => 'CP',
    '06' => 'CR',
    '07' => 'EP',
    '08' => 'FM',
    '09' => 'GD',
    '10' => 'IN',
    '11' => 'IB',
    '12' => 'LP',
    '13' => 'LE',
    '14' => 'OC',
    '15' => 'OL',
    '16' => 'SB',
    '17' => 'VA',
    '18' => 'YO',
  ],
  'HR' => [
    '01' => '07',
    '02' => '12',
    '03' => '19',
    '04' => '18',
    '05' => '04',
    '06' => '06',
    '07' => '02',
    '08' => '09',
    '09' => '20',
    '10' => '14',
    '11' => '11',
    '12' => '08',
    '13' => '15',
    '14' => '03',
    '15' => '17',
    '16' => '05',
    '17' => '10',
    '18' => '16',
    '19' => '13',
    '20' => '01',
    '21' => '21',
  ],
  'HT' => [
    '03' => 'NO',
    '06' => 'AR',
    '07' => 'CE',
    '09' => 'ND',
    '10' => 'NE',
    '11' => 'OU',
    '12' => 'SD',
    '13' => 'SE',
    '14' => 'GA',
    '15' => 'NI',
  ],
  'HU' => [
    '01' => 'BK',
    '02' => 'BA',
    '03' => 'BE',
    '04' => 'BZ',
    '05' => 'BU',
    '06' => 'CS',
    '07' => 'DE',
    '08' => 'FE',
    '09' => 'GS',
    '10' => 'HB',
    '11' => 'HE',
    '12' => 'KE',
    '13' => 'MI',
    '14' => 'NO',
    '15' => 'PS',
    '16' => 'PE',
    '17' => 'SO',
    '18' => 'SZ',
    '19' => 'SD',
    '20' => 'JN',
    '21' => 'TO',
    '22' => 'VA',
    '23' => 'VE',
    '24' => 'ZA',
    '25' => 'GY',
    '26' => 'BC',
    '27' => 'DU',
    '28' => 'EG',
    '29' => 'HV',
    '30' => 'KV',
    '31' => 'KM',
    '32' => 'NK',
    '33' => 'NY',
    '34' => 'SN',
    '35' => 'SF',
    '36' => 'SK',
    '37' => 'SH',
    '38' => 'TB',
    '39' => 'VM',
    '40' => 'ZE',
    '41' => 'ST',
    '42' => 'SS',
    '43' => 'ER',
  ],
  'ID' => [
    '01' => 'AC',
    '02' => 'BA',
    '03' => 'BE',
    '04' => 'JK',
    '05' => 'JA',
    '07' => 'JT',
    '08' => 'JI',
    '10' => 'YO',
    '11' => 'KB',
    '12' => 'KS',
    '13' => 'KT',
    '14' => 'KI',
    '15' => 'LA',
    '17' => 'NB',
    '18' => 'NT',
    '21' => 'ST',
    '22' => 'SG',
    '24' => 'SB',
    '26' => 'SU',
    '28' => 'MA',
    '29' => 'MU',
    '30' => 'JB',
    '31' => 'SA',
    '32' => 'SS',
    '33' => 'BT',
    '34' => 'GO',
    '35' => 'BB',
    '36' => 'PA',
    '37' => 'RI',
    '38' => 'SN',
    '39' => 'PB',
    '40' => 'KR',
    '41' => 'SR',
    '42' => 'KU',
  ],
  'IE' => [
    '01' => 'CW',
    '02' => 'CN',
    '03' => 'CE',
    '04' => 'CO',
    '06' => 'DL',
    '10' => 'G',
    '11' => 'KY',
    '12' => 'KE',
    '13' => 'KK',
    '14' => 'LM',
    '15' => 'LS',
    '16' => 'LK',
    '18' => 'LD',
    '19' => 'LH',
    '20' => 'MO',
    '21' => 'MH',
    '22' => 'MN',
    '23' => 'OY',
    '24' => 'RN',
    '25' => 'SO',
    '43' => 'TA',
    '27' => 'WD',
    '29' => 'WH',
    '30' => 'WX',
    '31' => 'WW',
    '42' => 'LK',
    '44' => 'WD',
  ],
  'IL' => [
    '01' => 'D',
    '02' => 'M',
    '03' => 'Z',
    '04' => 'HA',
    '05' => 'TA',
    '06' => 'JM',
  ],
  'IN' => [
    '01' => 'AN',
    '02' => 'AP',
    '03' => 'AS',
    '05' => 'CH',
    '06' => 'DN',
    '07' => 'DL',
    '09' => 'GJ',
    '10' => 'HR',
    '11' => 'HP',
    '12' => 'JK',
    '13' => 'KL',
    '14' => 'LD',
    '16' => 'MH',
    '17' => 'MN',
    '18' => 'ML',
    '19' => 'KA',
    '20' => 'NL',
    '21' => 'OR',
    '22' => 'PY',
    '23' => 'PB',
    '24' => 'RJ',
    '25' => 'TN',
    '26' => 'TR',
    '28' => 'WB',
    '29' => 'SK',
    '30' => 'AR',
    '31' => 'MZ',
    '32' => 'DD',
    '33' => 'GA',
    '34' => 'BR',
    '35' => 'MP',
    '36' => 'UP',
    '37' => 'CT',
    '38' => 'JH',
    '39' => 'UT',
    '40' => 'TG',
    '41' => 'LA',
  ],
  'IQ' => [
    '01' => 'AN',
    '02' => 'BA',
    '03' => 'MU',
    '04' => 'QA',
    '05' => 'SU',
    '06' => 'BB',
    '07' => 'BG',
    '08' => 'DA',
    '09' => 'DQ',
    '10' => 'DI',
    '11' => 'AR',
    '12' => 'KA',
    '13' => 'KI',
    '14' => 'MA',
    '15' => 'NI',
    '16' => 'WA',
    '17' => 'NA',
    '18' => 'SD',
  ],
  'IR' => [
    '01' => '02',
    '03' => '08',
    '04' => '13',
    '05' => '18',
    '07' => '14',
    '08' => '19',
    '09' => '24',
    '10' => '05',
    '11' => '23',
    '13' => '17',
    '15' => '10',
    '16' => '16',
    '22' => '06',
    '23' => '20',
    '25' => '12',
    '26' => '07',
    '28' => '04',
    '29' => '15',
    '30' => '09',
    '32' => '03',
    '33' => '01',
    '34' => '22',
    '35' => '21',
    '36' => '11',
    '37' => '27',
    '38' => '28',
    '39' => '26',
    '40' => '25',
    '41' => '29',
    '42' => '30',
    '43' => '31',
    '44' => '32',
  ],
  'IS' => [
    '38' => '7',
    '39' => '1',
    '40' => '6',
    '41' => '5',
    '42' => '8',
    '43' => '2',
    '44' => '4',
    '45' => '3',
  ],
  'IT' => [
    '01' => '65',
    '02' => '77',
    '03' => '78',
    '04' => '72',
    '05' => '45',
    '06' => '36',
    '07' => '62',
    '08' => '42',
    '09' => '25',
    '10' => '57',
    '11' => '67',
    '12' => '21',
    '13' => '75',
    '14' => '88',
    '15' => '82',
    '16' => '52',
    '17' => '32',
    '18' => '55',
    '19' => '23',
    '20' => '34',
  ],
  'JM' => [
    '01' => '13',
    '02' => '09',
    '04' => '12',
    '07' => '04',
    '08' => '02',
    '09' => '06',
    '10' => '14',
    '11' => '11',
    '12' => '08',
    '13' => '05',
    '14' => '03',
    '15' => '07',
    '16' => '10',
    '17' => '01',
  ],
  'JO' => [
    '02' => 'BA',
    '09' => 'KA',
    '12' => 'AT',
    '15' => 'MA',
    '16' => 'AM',
    '17' => 'AZ',
    '18' => 'IR',
    '19' => 'MN',
    '20' => 'AJ',
    '21' => 'AQ',
    '22' => 'JA',
    '23' => 'MD',
  ],
  'JP' => [
    '01' => '23',
    '02' => '05',
    '03' => '02',
    '04' => '12',
    '05' => '38',
    '06' => '18',
    '07' => '40',
    '08' => '07',
    '09' => '21',
    '10' => '10',
    '11' => '34',
    '12' => '01',
    '13' => '28',
    '14' => '08',
    '15' => '17',
    '16' => '03',
    '17' => '37',
    '18' => '46',
    '19' => '14',
    '20' => '39',
    '21' => '43',
    '22' => '26',
    '23' => '24',
    '24' => '04',
    '25' => '45',
    '26' => '20',
    '27' => '42',
    '28' => '29',
    '29' => '15',
    '30' => '44',
    '31' => '33',
    '32' => '27',
    '33' => '41',
    '34' => '11',
    '35' => '25',
    '36' => '32',
    '37' => '22',
    '38' => '09',
    '39' => '36',
    '40' => '13',
    '41' => '31',
    '42' => '16',
    '43' => '30',
    '44' => '06',
    '45' => '35',
    '46' => '19',
    '47' => '47',
  ],
  'KE' => [
    '01' => '200',
    '02' => '300',
    '03' => '400',
    '05' => '30',
    '06' => '500',
    '07' => '600',
    '08' => '700',
    '09' => '800',
    '10' => '01',
    '11' => '02',
    '12' => '03',
    '13' => '04',
    '14' => '05',
    '15' => '06',
    '16' => '07',
    '17' => '08',
    '18' => '09',
    '19' => '10',
    '20' => '11',
    '21' => '12',
    '22' => '13',
    '23' => '14',
    '24' => '15',
    '25' => '16',
    '26' => '17',
    '27' => '18',
    '28' => '19',
    '29' => '20',
    '30' => '21',
    '31' => '22',
    '32' => '23',
    '33' => '24',
    '34' => '25',
    '35' => '26',
    '36' => '27',
    '37' => '28',
    '38' => '29',
    '39' => '31',
    '40' => '32',
    '41' => '33',
    '42' => '34',
    '43' => '35',
    '44' => '36',
    '45' => '37',
    '46' => '38',
    '47' => '39',
    '48' => '40',
    '49' => '41',
    '50' => '42',
    '51' => '43',
    '52' => '44',
    '53' => '45',
    '54' => '46',
    '55' => '47',
  ],
  'KG' => [
    '01' => 'GB',
    '02' => 'C',
    '03' => 'J',
    '04' => 'N',
    '06' => 'T',
    '07' => 'Y',
    '08' => 'O',
    '09' => 'B',
    '10' => 'GO',
  ],
  'KH' => [
    '02' => '3',
    '03' => '4',
    '04' => '5',
    '05' => '6',
    '07' => '8',
    '08' => '9',
    '09' => '10',
    '10' => '11',
    '12' => '15',
    '13' => '13',
    '14' => '14',
    '17' => '19',
    '18' => '20',
    '19' => '21',
    '21' => '7',
    '22' => '12',
    '23' => '16',
    '24' => '17',
    '25' => '1',
    '26' => '23',
    '27' => '22',
    '28' => '18',
    '29' => '2',
    '30' => '24',
    '31' => '25',
  ],
  'KI' => [
    '01' => 'G',
    '02' => 'L',
    '03' => 'P',
  ],
  'KM' => [
    '01' => 'A',
    '02' => 'G',
    '03' => 'M',
  ],
  'KN' => [
    '01' => '01',
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
    '09' => '09',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '15' => '15',
  ],
  'KP' => [
    '01' => '04',
    '03' => '08',
    '06' => '05',
    '07' => '06',
    '09' => '07',
    '11' => '03',
    '12' => '01',
    '13' => '10',
    '15' => '02',
    '17' => '09',
    '18' => '13',
  ],
  'KR' => [
    '01' => '49',
    '03' => '45',
    '05' => '43',
    '06' => '42',
    '10' => '26',
    '11' => '11',
    '12' => '28',
    '13' => '41',
    '14' => '47',
    '15' => '27',
    '16' => '46',
    '17' => '44',
    '18' => '29',
    '19' => '30',
    '20' => '48',
    '21' => '31',
    '22' => '50',
  ],
  'KW' => [
    '02' => 'KU',
    '04' => 'AH',
    '05' => 'JA',
    '07' => 'FA',
    '08' => 'HA',
    '09' => 'MU',
  ],
  'KZ' => [
    '01' => 'ALM',
    '02' => 'ALA',
    '03' => 'AKM',
    '04' => 'AKT',
    '05' => 'AST',
    '06' => 'ATY',
    '07' => 'ZAP',
    '08' => 'BAY',
    '09' => 'MAN',
    '10' => 'YUZ',
    '11' => 'PAV',
    '12' => 'KAR',
    '13' => 'KUS',
    '14' => 'KZY',
    '15' => 'VOS',
    '18' => 'SHY',
    '16' => 'SEV',
    '17' => 'ZHA',
  ],
  'LA' => [
    '01' => 'AT',
    '02' => 'CH',
    '03' => 'HO',
    '07' => 'OU',
    '13' => 'XA',
    '14' => 'XI',
    '15' => 'KH',
    '16' => 'LM',
    '17' => 'LP',
    '18' => 'PH',
    '19' => 'SL',
    '20' => 'SV',
    '22' => 'BK',
    '23' => 'BL',
    '24' => 'VT',
    '25' => 'XN',
    '26' => 'XE',
    '27' => 'VI',
    '28' => 'XS',
  ],
  'LB' => [
    '04' => 'BA',
    '05' => 'JL',
    '06' => 'JA',
    '07' => 'NA',
    '08' => 'BI',
    '09' => 'AS',
    '10' => 'AK',
    '11' => 'BH',
  ],
  'LC' => [
    '01' => '01',
    '03' => '02',
    '04' => '03',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
    '09' => '10',
    '10' => '11',
    '12' => '12',
  ],
  'LI' => [
    '01' => '01',
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
    '09' => '09',
    '10' => '10',
    '11' => '11',
  ],
  'LK' => [
    '29' => '2',
    '30' => '7',
    '32' => '6',
    '33' => '9',
    '34' => '3',
    '35' => '8',
    '36' => '1',
    '37' => '5',
    '38' => '4',
  ],
  'LR' => [
    '01' => 'BG',
    '09' => 'NI',
    '10' => 'SI',
    '11' => 'GB',
    '12' => 'CM',
    '13' => 'MY',
    '14' => 'MO',
    '15' => 'BM',
    '16' => 'GK',
    '17' => 'MG',
    '18' => 'RI',
    '19' => 'GG',
    '20' => 'LO',
    '21' => 'GP',
    '22' => 'RG',
  ],
  'LS' => [
    '10' => 'D',
    '11' => 'B',
    '12' => 'C',
    '13' => 'E',
    '14' => 'A',
    '15' => 'F',
    '16' => 'J',
    '17' => 'H',
    '18' => 'G',
    '19' => 'K',
  ],
  'LT' => [
    '56' => 'AL',
    '57' => 'KU',
    '58' => 'KL',
    '59' => 'MR',
    '60' => 'PN',
    '61' => 'SA',
    '62' => 'TA',
    '63' => 'TE',
    '64' => 'UT',
    '65' => 'VL',
    '68' => '02',
    '70' => '05',
    'C6' => '57',
    '72' => '07',
    '90' => '25',
    '81' => '15',
    '86' => '20',
    '93' => '28',
    '96' => '31',
    '98' => '32',
    'B1' => '43',
    'C7' => '59',
    '66' => '01',
    '67' => '03',
    '69' => '04',
    '71' => '06',
    'C3' => '55',
    'C4' => '56',
    'C5' => '58',
    '73' => '08',
    'C8' => '60',
    '74' => '09',
    '75' => '10',
    '76' => '11',
    '79' => '14',
    '78' => '13',
    '80' => '16',
    '83' => '18',
    '84' => '19',
    '85' => '21',
    '87' => '22',
    '88' => '23',
    '82' => '17',
    '89' => '24',
    '91' => '26',
    '92' => '27',
    '94' => '29',
    '95' => '30',
    '97' => '33',
    '99' => '34',
    'A1' => '35',
    'A2' => '36',
    'A3' => '37',
    'A4' => '38',
    'A6' => '40',
    'A5' => '39',
    'B5' => '48',
    'B7' => '50',
    'B8' => '51',
    'B9' => '52',
    'C1' => '53',
    'C2' => '54',
    'A7' => '41',
    'A8' => '42',
    'B6' => '49',
    'B2' => '45',
    'B3' => '46',
    'B4' => '47',
    'A9' => '44',
    '77' => '12',
  ],
  'LU' => [
    '01' => 'D',
    '02' => 'G',
    '03' => 'L',
    '04' => 'CA',
    '05' => 'CL',
    '06' => 'DI',
    '07' => 'EC',
    '08' => 'ES',
    '09' => 'GR',
    '10' => 'LU',
    '11' => 'ME',
    '12' => 'RD',
    '13' => 'RM',
    '14' => 'VD',
    '15' => 'WI',
  ],
  'LV' => [
    '36' => '002',
    '41' => '007',
    '48' => '015',
    '49' => '016',
    '54' => '022',
    '06' => 'DGV',
    '58' => '025',
    '59' => '026',
    '66' => '033',
    '75' => '042',
    '11' => 'JEL',
    '76' => '041',
    '13' => 'JUR',
    '83' => '047',
    '86' => '050',
    '16' => 'LPX',
    '89' => '054',
    '92' => '058',
    '93' => '059',
    'A1' => '067',
    'A7' => '073',
    '23' => 'REZ',
    'B2' => '077',
    '25' => 'RIX',
    'C4' => '088',
    'D4' => '097',
    'D6' => '099',
    'D8' => '101',
    'D9' => 'VMR',
    '32' => 'VEN',
    'E5' => '106',
    '34' => '011',
    '35' => '001',
    '37' => '003',
    '38' => '004',
    '39' => '005',
    '40' => '006',
    '42' => '008',
    '43' => '009',
    '44' => '010',
    '45' => '012',
    '46' => '013',
    '47' => '014',
    '50' => '017',
    '51' => '018',
    '52' => '019',
    '53' => '020',
    '55' => '021',
    '56' => '023',
    '57' => '024',
    '60' => '027',
    '61' => '028',
    '62' => '029',
    '63' => '030',
    '64' => '031',
    '65' => '032',
    '67' => '034',
    '68' => '035',
    '69' => '036',
    '70' => '037',
    '71' => '038',
    '72' => '039',
    '73' => '040',
    '74' => 'JKB',
    '77' => '043',
    '78' => '044',
    '79' => '051',
    '80' => '052',
    '81' => '045',
    '82' => '046',
    '84' => '048',
    '85' => '049',
    '87' => '053',
    '88' => '055',
    '90' => '056',
    '91' => '057',
    '94' => '061',
    '95' => '062',
    '96' => '060',
    '97' => '064',
    '98' => '065',
    '99' => '066',
    'A2' => '068',
    'A3' => '069',
    'A4' => '070',
    'A5' => '071',
    'A6' => '072',
    'A8' => '074',
    'A9' => '075',
    'B1' => '076',
    'B3' => '078',
    'B4' => '079',
    'B5' => '080',
    'B6' => '081',
    'B7' => '082',
    'B8' => '084',
    'B9' => '083',
    'C1' => '086',
    'C2' => '085',
    'C3' => '087',
    'C5' => '089',
    'C6' => '090',
    'C7' => '091',
    'C8' => '092',
    'C9' => '093',
    'D1' => '094',
    'D2' => '095',
    'D3' => '096',
    'D5' => '098',
    'D7' => '100',
    'E1' => '102',
    'E2' => '103',
    'E3' => '104',
    'E4' => '105',
    'E6' => '107',
    'E7' => '108',
    'E8' => '109',
    'E9' => '110',
    'F1' => '063',
  ],
  'LY' => [
    '63' => 'JA',
    '64' => 'JU',
    '65' => 'KF',
    '66' => 'MJ',
    '67' => 'NQ',
    '68' => 'ZA',
    '69' => 'BA',
    '70' => 'DR',
    '71' => 'GT',
    '72' => 'MI',
    '73' => 'MQ',
    '74' => 'NL',
    '75' => 'SB',
    '76' => 'SR',
    '77' => 'TB',
    '78' => 'WS',
    '79' => 'BU',
    '80' => 'JG',
    '81' => 'JI',
    '82' => 'MB',
    '83' => 'WA',
    '84' => 'WD',
  ],
  'MA' => [
    '70' => '01',
    '67' => '02',
    '63' => '03',
    '68' => '04',
    '60' => '05',
    '61' => '06',
    '66' => '07',
    '62' => '08',
    '69' => '09',
    '64' => '10',
    '65' => '11',
    '45' => '08',
    '46' => '05',
    '47' => '11',
    '48' => '06',
    '49' => '07',
    '50' => '09',
    '51' => '10',
    '52' => '02',
    '53' => '14',
    '54' => '04',
    '55' => '13',
    '56' => '12',
    '57' => '01',
    '58' => '03',
    '59' => '15',
  ],
  'MD' => [
    '51' => 'GA',
    '57' => 'CU',
    '58' => 'SN',
    '59' => 'AN',
    '60' => 'BA',
    '61' => 'BS',
    '62' => 'BD',
    '63' => 'BR',
    '64' => 'CA',
    '65' => 'CT',
    '66' => 'CL',
    '67' => 'CS',
    '68' => 'CM',
    '69' => 'CR',
    '70' => 'DO',
    '71' => 'DR',
    '72' => 'DU',
    '73' => 'ED',
    '74' => 'FA',
    '75' => 'FL',
    '76' => 'GL',
    '77' => 'HI',
    '78' => 'IA',
    '79' => 'LE',
    '80' => 'NI',
    '81' => 'OC',
    '82' => 'OR',
    '83' => 'RE',
    '84' => 'RI',
    '85' => 'SI',
    '86' => 'SD',
    '87' => 'SO',
    '88' => 'SV',
    '89' => 'ST',
    '90' => 'TA',
    '91' => 'TE',
    '92' => 'UN',
  ],
  'ME' => [
    '01' => '01',
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
    '09' => '09',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
    '20' => '20',
    '21' => '21',
    '22' => '22',
    '23' => '23',
    '24' => '24',
  ],
  'MG' => [
    '01' => 'D',
    '02' => 'F',
    '03' => 'M',
    '04' => 'A',
    '05' => 'T',
    '06' => 'U',
  ],
  'MH' => [
    '01' => 'ALL',
    '02' => 'ALK',
    '03' => 'ARN',
    '04' => 'AUR',
    '06' => 'EBO',
    '07' => 'ENI',
    '08' => 'JAB',
    '09' => 'JAL',
    '05' => 'KIL',
    '10' => 'KWA',
    '11' => 'LAE',
    '12' => 'LIB',
    '13' => 'LIK',
    '14' => 'MAJ',
    '15' => 'MAL',
    '16' => 'MEJ',
    '17' => 'MIL',
    '18' => 'NMK',
    '19' => 'NMU',
    '20' => 'RON',
    '21' => 'UJA',
    '22' => 'UTI',
    '23' => 'WTH',
    '24' => 'WTJ',
  ],
  'MK' => [
    '01' => '802',
    '04' => '201',
    '06' => '501',
    '08' => '401',
    '11' => '402',
    '12' => '602',
    '18' => '313',
    '19' => '210',
    '20' => '816',
    '22' => '203',
    '25' => '103',
    '28' => '503',
    '30' => '28',
    '33' => '405',
    '35' => '102',
    '36' => '807',
    '40' => '205',
    '43' => '307',
    '46' => '206',
    '47' => '407',
    '51' => '701',
    '52' => '702',
    '53' => '504',
    '54' => '505',
    '59' => '704',
    '60' => '105',
    '62' => '207',
    '69' => '106',
    '72' => '408',
    '77' => '57',
    '78' => '208',
    '79' => '810',
    '80' => '311',
    '83' => '209',
    '84' => '409',
    '85' => '705',
    '86' => '509',
    '87' => '107',
    '92' => '812',
    '97' => '706',
    '98' => '211',
    'A2' => '813',
    'A4' => '108',
    'A5' => '608',
    'A9' => '404',
    'B3' => '301',
    'F2' => '202',
    'B6' => '15',
    'B7' => '603',
    'C1' => '31',
    'C2' => '806',
    'C3' => '605',
    'C6' => '204',
    'C7' => '601',
    'C9' => '109',
    'D2' => '303',
    'D3' => '502',
    'D4' => '604',
    'D5' => '606',
    'D6' => '104',
    'D7' => '703',
    'D8' => '308',
    'D9' => '506',
    'E1' => '507',
    'E2' => '310',
    'E3' => '508',
    'E4' => '607',
    'E5' => '406',
    'E6' => '312',
    'E7' => '410',
    'E8' => '609',
    'E9' => '403',
    'F1' => '101',
    'F5' => '304',
    '29' => '805',
    '32' => '804',
    '41' => '808',
    '44' => '809',
    '90' => '811',
    'A3' => '817',
    'C8' => '815',
    'D1' => '814',
    'F3' => '801',
    'F4' => '803',
  ],
  'ML' => [
    '01' => 'BKO',
    '03' => '1',
    '04' => '5',
    '05' => '4',
    '06' => '3',
    '07' => '2',
    '08' => '6',
    '09' => '7',
    '10' => '8',
  ],
  'MM' => [
    '01' => '16',
    '02' => '14',
    '03' => '07',
    '04' => '11',
    '05' => '13',
    '06' => '12',
    '08' => '04',
    '10' => '01',
    '11' => '17',
    '12' => '05',
    '13' => '15',
    '15' => '03',
    '16' => '02',
    '17' => '06',
    '18' => '18',
  ],
  'MN' => [
    '01' => '073',
    '02' => '069',
    '03' => '071',
    '06' => '061',
    '07' => '063',
    '08' => '059',
    '09' => '057',
    '10' => '065',
    '11' => '039',
    '12' => '043',
    '13' => '041',
    '14' => '053',
    '15' => '055',
    '16' => '049',
    '17' => '051',
    '18' => '047',
    '19' => '046',
    '20' => '1',
    '21' => '067',
    '23' => '037',
    '24' => '064',
    '25' => '035',
  ],
  'MP' => [
    '85' => 'N',
    '100' => 'R',
    '110' => 'S',
    '120' => 'T',
  ],
  'MR' => [
    '01' => '01',
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
    '09' => '09',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
  ],
  'MT' => [
    '01' => '01',
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
    '09' => '09',
    '10' => '10',
    '11' => '13',
    '12' => '14',
    '13' => '15',
    '14' => '16',
    '15' => '17',
    '16' => '11',
    '17' => '12',
    '18' => '18',
    '19' => '19',
    '20' => '29',
    '21' => '31',
    '22' => '33',
    '23' => '34',
    '24' => '35',
    '25' => '20',
    '26' => '21',
    '27' => '22',
    '28' => '23',
    '29' => '24',
    '30' => '25',
    '31' => '26',
    '32' => '27',
    '33' => '28',
    '34' => '30',
    '35' => '32',
    '36' => '36',
    '37' => '37',
    '38' => '38',
    '39' => '39',
    '40' => '40',
    '41' => '41',
    '42' => '42',
    '43' => '43',
    '44' => '44',
    '45' => '46',
    '46' => '45',
    '47' => '47',
    '48' => '49',
    '49' => '48',
    '50' => '50',
    '51' => '53',
    '52' => '51',
    '53' => '54',
    '54' => '52',
    '55' => '55',
    '56' => '56',
    '57' => '57',
    '58' => '58',
    '59' => '59',
    '60' => '60',
    '61' => '61',
    '62' => '62',
    '63' => '63',
    '64' => '64',
    '65' => '66',
    '66' => '65',
    '67' => '67',
    '68' => '68',
  ],
  'MU' => [
    '12' => 'BL',
    '13' => 'FL',
    '14' => 'GP',
    '15' => 'MO',
    '16' => 'PA',
    '17' => 'PW',
    '18' => 'PL',
    '19' => 'RR',
    '20' => 'SA',
    '21' => 'AG',
    '22' => 'CC',
    '23' => 'RO',
  ],
  'MV' => [
    '40' => 'MLE',
    '48' => 'SU',
    '49' => 'US',
    '50' => 'UN',
    '51' => 'CE',
    '52' => 'SC',
    '53' => 'NC',
    '54' => 'NO',
  ],
  'MW' => [
    '02' => 'CK',
    '03' => 'CR',
    '04' => 'CT',
    '05' => 'TH',
    '06' => 'DE',
    '07' => 'DO',
    '08' => 'KR',
    '09' => 'KS',
    '11' => 'LI',
    '12' => 'MG',
    '13' => 'MC',
    '15' => 'MZ',
    '16' => 'NU',
    '17' => 'NB',
    '18' => 'NK',
    '19' => 'NS',
    '20' => 'NI',
    '21' => 'RU',
    '22' => 'SA',
    '23' => 'ZO',
    '24' => 'BL',
    '25' => 'MW',
    '26' => 'BA',
    '27' => 'LK',
    '28' => 'MH',
    '29' => 'MU',
    '30' => 'PH',
    '31' => 'NE',
  ],
  'MX' => [
    '01' => 'AGU',
    '02' => 'BCN',
    '03' => 'BCS',
    '04' => 'CAM',
    '05' => 'CHP',
    '06' => 'CHH',
    '07' => 'COA',
    '08' => 'COL',
    '09' => 'CMX',
    '10' => 'DUR',
    '11' => 'GUA',
    '12' => 'GRO',
    '13' => 'HID',
    '14' => 'JAL',
    '15' => 'MEX',
    '16' => 'MIC',
    '17' => 'MOR',
    '18' => 'NAY',
    '19' => 'NLE',
    '20' => 'OAX',
    '21' => 'PUE',
    '22' => 'QUE',
    '23' => 'ROO',
    '24' => 'SLP',
    '25' => 'SIN',
    '26' => 'SON',
    '27' => 'TAB',
    '28' => 'TAM',
    '29' => 'TLA',
    '30' => 'VER',
    '31' => 'YUC',
    '32' => 'ZAC',
  ],
  'MY' => [
    '01' => '01',
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
    '07' => '08',
    '08' => '09',
    '09' => '07',
    '11' => '13',
    '12' => '10',
    '13' => '11',
    '14' => '14',
    '15' => '15',
    '16' => '12',
    '17' => '16',
  ],
  'MZ' => [
    '01' => 'P',
    '02' => 'G',
    '03' => 'I',
    '04' => 'L',
    '05' => 'S',
    '06' => 'N',
    '07' => 'A',
    '08' => 'T',
    '09' => 'Q',
    '10' => 'B',
    '11' => 'MPM',
  ],
  'NA' => [
    '21' => 'KH',
    '28' => 'CA',
    '29' => 'ER',
    '30' => 'HA',
    '31' => 'KA',
    '32' => 'KU',
    '33' => 'OW',
    '34' => 'OK',
    '35' => 'OH',
    '36' => 'OS',
    '37' => 'ON',
    '38' => 'OT',
    '39' => 'OD',
    '40' => 'KE',
    '41' => 'KW',
  ],
  'NC' => [
    '02' => 'N',
    '03' => 'S',
    '01' => 'L',
  ],
  'NE' => [
    '01' => '1',
    '02' => '2',
    '03' => '3',
    '04' => '4',
    '06' => '5',
    '07' => '7',
    '08' => '8',
    '09' => '6',
  ],
  'NG' => [
    '05' => 'LA',
    '11' => 'FC',
    '16' => 'OG',
    '21' => 'AK',
    '22' => 'CR',
    '23' => 'KD',
    '24' => 'KT',
    '25' => 'AN',
    '26' => 'BE',
    '27' => 'BO',
    '28' => 'IM',
    '29' => 'KN',
    '30' => 'KW',
    '31' => 'NI',
    '32' => 'OY',
    '35' => 'AD',
    '36' => 'DE',
    '37' => 'ED',
    '39' => 'JI',
    '40' => 'KE',
    '41' => 'KO',
    '42' => 'OS',
    '43' => 'TA',
    '44' => 'YO',
    '45' => 'AB',
    '46' => 'BA',
    '47' => 'EN',
    '48' => 'ON',
    '49' => 'PL',
    '50' => 'RI',
    '51' => 'SO',
    '52' => 'BY',
    '53' => 'EB',
    '54' => 'EK',
    '55' => 'GO',
    '56' => 'NA',
    '57' => 'ZA',
  ],
  'NI' => [
    '01' => 'BO',
    '02' => 'CA',
    '03' => 'CI',
    '04' => 'CO',
    '05' => 'ES',
    '06' => 'GR',
    '07' => 'JI',
    '08' => 'LE',
    '09' => 'MD',
    '10' => 'MN',
    '11' => 'MS',
    '12' => 'MT',
    '13' => 'NS',
    '14' => 'SJ',
    '15' => 'RI',
    '17' => 'AN',
    '18' => 'AS',
  ],
  'NL' => [
    '01' => 'DR',
    '02' => 'FR',
    '03' => 'GE',
    '04' => 'GR',
    '05' => 'LI',
    '06' => 'NB',
    '07' => 'NH',
    '09' => 'UT',
    '10' => 'ZE',
    '11' => 'ZH',
    '15' => 'OV',
    '16' => 'FL',
  ],
  'NO' => [
    '01' => '02',
    '02' => '09',
    '04' => '06',
    '05' => '20',
    '06' => '04',
    '07' => '12',
    '08' => '15',
    '09' => '18',
    '10' => '17',
    '11' => '05',
    '12' => '03',
    '13' => '01',
    '14' => '11',
    '15' => '14',
    '16' => '16',
    '17' => '08',
    '18' => '19',
    '19' => '10',
    '20' => '07',
    '21' => '50',
  ],
  'NP' => [
    '01' => 'BA',
    '02' => 'BH',
    '03' => 'DH',
    '04' => 'GA',
    '05' => 'JA',
    '06' => 'KA',
    '07' => 'KO',
    '08' => 'LU',
    '09' => 'MA',
    '10' => 'ME',
    '11' => 'NA',
    '12' => 'RA',
    '13' => 'SA',
    '14' => 'SE',
  ],
  'NR' => [
    '01' => '01',
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
    '09' => '09',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
  ],
  'NZ' => [
    '10' => 'CIT',
    'E7' => 'AUK',
    'E8' => 'BOP',
    'E9' => 'CAN',
    'F1' => 'GIS',
    'F2' => 'HKB',
    'F3' => 'MWT',
    'F4' => 'MBH',
    'F5' => 'NSN',
    'F6' => 'NTL',
    'F7' => 'OTA',
    'F8' => 'STL',
    'F9' => 'TKI',
    'G1' => 'WKO',
    'G2' => 'WGN',
    'G3' => 'WTC',
    'G4' => 'TAS',
  ],
  'OM' => [
    '01' => 'DA',
    '02' => 'BJ',
    '03' => 'WU',
    '04' => 'SJ',
    '06' => 'MA',
    '07' => 'MU',
    '08' => 'ZU',
    '09' => 'ZA',
    '10' => 'BU',
    '11' => 'BS',
    '12' => 'SS',
  ],
  'PA' => [
    '01' => '1',
    '02' => '4',
    '03' => '2',
    '04' => '3',
    '05' => '5',
    '06' => '6',
    '07' => '7',
    '08' => '8',
    '09' => 'KY',
    '10' => '9',
    '11' => 'EM',
    '12' => 'NB',
    '13' => '10',
  ],
  'PE' => [
    '01' => 'AMA',
    '02' => 'ANC',
    '03' => 'APU',
    '04' => 'ARE',
    '05' => 'AYA',
    '06' => 'CAJ',
    '07' => 'CAL',
    '08' => 'CUS',
    '09' => 'HUV',
    '10' => 'HUC',
    '11' => 'ICA',
    '12' => 'JUN',
    '13' => 'LAL',
    '14' => 'LAM',
    '15' => 'LIM',
    '16' => 'LOR',
    '17' => 'MDD',
    '18' => 'MOQ',
    '19' => 'PAS',
    '20' => 'PIU',
    '21' => 'PUN',
    '22' => 'SAM',
    '23' => 'TAC',
    '24' => 'TUM',
    '25' => 'UCA',
    '26' => 'LMA',
  ],
  'PF' => [
    '02' => 'V',
    '04' => 'S',
    '05' => 'T',
    '03' => 'M',
    '01' => 'I',
  ],
  'PG' => [
    '01' => 'CPM',
    '02' => 'GPK',
    '03' => 'MBA',
    '04' => 'NPP',
    '05' => 'SHM',
    '06' => 'WPD',
    '07' => 'NSB',
    '08' => 'CPK',
    '09' => 'EHG',
    '10' => 'EBR',
    '11' => 'ESW',
    '12' => 'MPM',
    '13' => 'MRL',
    '14' => 'MPL',
    '15' => 'NIK',
    '16' => 'WHM',
    '17' => 'WBK',
    '18' => 'SAN',
    '19' => 'EPW',
    '20' => 'NCD',
    '21' => 'HLA',
    '22' => 'JWK',
  ],
  'PH' => [
    '01' => 'ABR',
    '02' => 'AGN',
    '03' => 'AGS',
    '04' => 'AKL',
    '05' => 'ALB',
    '06' => 'ANT',
    '07' => 'BAN',
    '08' => 'BTN',
    '09' => 'BTG',
    '10' => 'BEN',
    '11' => 'BOH',
    '12' => 'BUK',
    '13' => 'BUL',
    '14' => 'CAG',
    '15' => 'CAN',
    '16' => 'CAS',
    '17' => 'CAM',
    '18' => 'CAP',
    '19' => 'CAT',
    '20' => 'CAV',
    '21' => 'CEB',
    '22' => 'BAS',
    '23' => 'EAS',
    '25' => 'DAS',
    '26' => 'DAO',
    '27' => 'IFU',
    '28' => 'ILN',
    '29' => 'ILS',
    '30' => 'ILI',
    '31' => 'ISA',
    'J7' => 'KAL',
    '33' => 'LAG',
    '34' => 'LAN',
    '35' => 'LAS',
    '36' => 'LUN',
    '37' => 'LEY',
    '38' => 'MAD',
    '39' => 'MAS',
    '40' => 'MDC',
    '41' => 'MDR',
    '42' => 'MSC',
    '43' => 'MSR',
    '44' => 'MOU',
    '46' => 'NER',
    '47' => 'NUE',
    '48' => 'NUV',
    '49' => 'PLW',
    '50' => 'PAM',
    '51' => 'PAN',
    '53' => 'RIZ',
    '54' => 'ROM',
    '55' => 'WSA',
    '56' => 'MAG',
    '57' => 'NCO',
    '58' => 'SOR',
    '59' => 'SLE',
    '60' => 'SLU',
    'N3' => 'SUN',
    '62' => 'SUR',
    '63' => 'TAR',
    '64' => 'ZMB',
    '65' => 'ZAN',
    '66' => 'ZAS',
    '67' => 'NSA',
    '68' => 'QUI',
    '69' => 'SIG',
    '70' => 'SCO',
    '71' => 'SUK',
    '72' => 'TAW',
    'G8' => 'AUR',
    'H2' => 'QUE',
    'H3' => 'NEC',
    'H6' => 'APA',
    'H9' => 'BIL',
    'I6' => 'COM',
    'I7' => 'DAV',
    'I9' => 'DIN',
    'J3' => 'GUI',
    'M9' => 'SAR',
    'P3' => 'DVO',
    'P2' => 'ZSI',
  ],
  'PK' => [
    '01' => 'TA',
    '02' => 'BA',
    '03' => 'KP',
    '04' => 'PB',
    '05' => 'SD',
    '06' => 'JK',
    '07' => 'GB',
    '08' => 'IS',
  ],
  'PL' => [
    '72' => '02',
    '73' => '04',
    '74' => '10',
    '75' => '06',
    '76' => '08',
    '77' => '12',
    '78' => '14',
    '79' => '16',
    '80' => '18',
    '81' => '20',
    '82' => '22',
    '83' => '24',
    '84' => '26',
    '85' => '28',
    '86' => '30',
    '87' => '32',
  ],
  'PS' => [
    '05' => 'JEN',
    '04' => 'BTH',
    '06' => 'NBS',
    '11' => 'TKM',
    '10' => 'TBS',
    '07' => 'QQA',
    '09' => 'SLT',
    '03' => 'JRH',
    '02' => 'JEM',
    '08' => 'RBH',
    '01' => 'HBN',
  ],
  'PT' => [
    '02' => '01',
    '03' => '02',
    '04' => '03',
    '05' => '04',
    '06' => '05',
    '07' => '06',
    '08' => '07',
    '09' => '08',
    '10' => '30',
    '11' => '09',
    '13' => '10',
    '14' => '11',
    '16' => '12',
    '17' => '13',
    '18' => '14',
    '19' => '15',
    '20' => '16',
    '21' => '17',
    '22' => '18',
    '23' => '20',
  ],
  'PW' => [
    '01' => '002',
    '02' => '004',
    '03' => '010',
    '04' => '050',
    '05' => '100',
    '06' => '150',
    '07' => '212',
    '08' => '214',
    '09' => '218',
    '10' => '222',
    '11' => '224',
    '12' => '226',
    '13' => '227',
    '14' => '228',
    '15' => '350',
    '16' => '370',
  ],
  'PY' => [
    '01' => '10',
    '02' => '13',
    '04' => '5',
    '05' => '6',
    '06' => '11',
    '07' => '1',
    '08' => '3',
    '10' => '4',
    '11' => '7',
    '12' => '8',
    '13' => '12',
    '15' => '9',
    '16' => '15',
    '17' => '2',
    '19' => '14',
    '22' => 'ASU',
    '23' => '16',
    '24' => '19',
  ],
  'QA' => [
    '01' => 'DA',
    '04' => 'KH',
    '06' => 'RA',
    '08' => 'MS',
    '09' => 'US',
    '10' => 'WA',
    '13' => 'ZA',
    '14' => 'SH',
  ],
  'RO' => [
    '01' => 'AB',
    '02' => 'AR',
    '03' => 'AG',
    '04' => 'BC',
    '05' => 'BH',
    '06' => 'BN',
    '07' => 'BT',
    '08' => 'BR',
    '09' => 'BV',
    '10' => 'B',
    '11' => 'BZ',
    '12' => 'CS',
    '13' => 'CJ',
    '14' => 'CT',
    '15' => 'CV',
    '16' => 'DB',
    '17' => 'DJ',
    '18' => 'GL',
    '19' => 'GJ',
    '20' => 'HR',
    '21' => 'HD',
    '22' => 'IL',
    '23' => 'IS',
    '25' => 'MM',
    '26' => 'MH',
    '27' => 'MS',
    '28' => 'NT',
    '29' => 'OT',
    '30' => 'PH',
    '31' => 'SJ',
    '32' => 'SM',
    '33' => 'SB',
    '34' => 'SV',
    '35' => 'TR',
    '36' => 'TM',
    '37' => 'TL',
    '38' => 'VS',
    '39' => 'VL',
    '40' => 'VN',
    '41' => 'CL',
    '42' => 'GR',
    '43' => 'IF',
  ],
  'RU' => [
    '01' => 'AD',
    '03' => 'AL',
    '04' => 'ALT',
    '05' => 'AMU',
    '06' => 'ARK',
    '07' => 'AST',
    '08' => 'BA',
    '09' => 'BEL',
    '10' => 'BRY',
    '11' => 'BU',
    '12' => 'CE',
    '13' => 'CHE',
    '15' => 'CHU',
    '16' => 'CU',
    '17' => 'DA',
    '19' => 'IN',
    '20' => 'IRK',
    '21' => 'IVA',
    '22' => 'KB',
    '23' => 'KGD',
    '24' => 'KL',
    '25' => 'KLU',
    '27' => 'KC',
    '28' => 'KR',
    '29' => 'KEM',
    '30' => 'KHA',
    '31' => 'KK',
    '32' => 'KHM',
    '33' => 'KIR',
    '34' => 'KO',
    '37' => 'KOS',
    '38' => 'KDA',
    '40' => 'KGN',
    '41' => 'KRS',
    '42' => 'LEN',
    '43' => 'LIP',
    '44' => 'MAG',
    '45' => 'ME',
    '46' => 'MO',
    '47' => 'MOS',
    '48' => 'MOW',
    '49' => 'MUR',
    '50' => 'NEN',
    '51' => 'NIZ',
    '52' => 'NGR',
    '53' => 'NVS',
    '54' => 'OMS',
    '55' => 'ORE',
    '56' => 'ORL',
    '57' => 'PNZ',
    '59' => 'PRI',
    '60' => 'PSK',
    '61' => 'ROS',
    '62' => 'RYA',
    '63' => 'SA',
    '64' => 'SAK',
    '65' => 'SAM',
    '66' => 'SPE',
    '67' => 'SAR',
    '68' => 'SE',
    '69' => 'SMO',
    '70' => 'STA',
    '71' => 'SVE',
    '72' => 'TAM',
    '73' => 'TA',
    '75' => 'TOM',
    '76' => 'TUL',
    '77' => 'TVE',
    '78' => 'TYU',
    '79' => 'TY',
    '80' => 'UD',
    '81' => 'ULY',
    '83' => 'VLA',
    '84' => 'VGG',
    '85' => 'VLG',
    '86' => 'VOR',
    '87' => 'YAN',
    '88' => 'YAR',
    '89' => 'YEV',
    '90' => 'PER',
    '91' => 'KYA',
    '92' => 'KAM',
    '93' => 'ZAB',
  ],
  'RW' => [
    '11' => '02',
    '12' => '01',
    '13' => '03',
    '14' => '04',
    '15' => '05',
  ],
  'SA' => [
    '02' => '11',
    '05' => '03',
    '06' => '04',
    '08' => '05',
    '10' => '01',
    '11' => '14',
    '13' => '06',
    '14' => '02',
    '15' => '08',
    '16' => '10',
    '17' => '09',
    '19' => '07',
    '20' => '12',
  ],
  'SB' => [
    '03' => 'ML',
    '06' => 'GU',
    '07' => 'IS',
    '08' => 'MK',
    '09' => 'TE',
    '10' => 'CE',
    '11' => 'WE',
    '12' => 'CH',
    '13' => 'RB',
    '14' => 'CT',
  ],
  'SC' => [
    '01' => '01',
    '02' => '02',
    '03' => '03',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
    '09' => '09',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '14' => '14',
    '17' => '17',
    '18' => '18',
    '19' => '19',
    '20' => '20',
    '22' => '22',
    '23' => '23',
    '24' => '13',
    '25' => '15',
    '26' => '16',
    '27' => '21',
    '28' => '04',
    '29' => '24',
    '30' => '25',
  ],
  'SD' => [
    '29' => 'KH',
    '36' => 'RS',
    '38' => 'GZ',
    '39' => 'GD',
    '41' => 'NW',
    '42' => 'NB',
    '43' => 'NO',
    '47' => 'DW',
    '49' => 'DS',
    '50' => 'KS',
    '52' => 'KA',
    '53' => 'NR',
    '55' => 'DN',
    '56' => 'KN',
    '58' => 'SI',
    '60' => 'DE',
    '61' => 'DC',
    '62' => 'GK',
  ],
  'SE' => [
    '02' => 'K',
    '03' => 'X',
    '05' => 'I',
    '06' => 'N',
    '07' => 'Z',
    '08' => 'F',
    '09' => 'H',
    '10' => 'W',
    '12' => 'G',
    '14' => 'BD',
    '15' => 'T',
    '16' => 'E',
    '18' => 'D',
    '21' => 'C',
    '22' => 'S',
    '23' => 'AC',
    '24' => 'Y',
    '25' => 'U',
    '26' => 'AB',
    '27' => 'M',
    '28' => 'O',
  ],
  'SH' => [
    '01' => 'AC',
    '02' => 'HL',
    '03' => 'TA',
  ],
  'SI' => [
    '01' => '001',
    '02' => '002',
    '03' => '003',
    '04' => '004',
    '05' => '005',
    '06' => '006',
    '07' => '007',
    '08' => '009',
    '09' => '008',
    '11' => '011',
    '12' => '012',
    '13' => '013',
    '14' => '014',
    '15' => '015',
    '16' => '016',
    '17' => '017',
    '19' => '019',
    '20' => '020',
    '22' => '022',
    '24' => '024',
    '25' => '025',
    '26' => '026',
    '27' => '027',
    '28' => '028',
    '29' => '029',
    '30' => '030',
    '31' => '031',
    '32' => '032',
    '34' => '034',
    '35' => '035',
    '36' => '036',
    '37' => '037',
    '38' => '038',
    '39' => '039',
    '40' => '040',
    '42' => '042',
    '44' => '044',
    '45' => '045',
    '46' => '046',
    '47' => '047',
    '49' => '049',
    '50' => '050',
    '51' => '051',
    '52' => '052',
    '53' => '053',
    '54' => '054',
    '55' => '055',
    '57' => '057',
    '61' => '061',
    '62' => '062',
    '64' => '064',
    '66' => '066',
    '68' => '068',
    '71' => '071',
    '72' => '072',
    '73' => '073',
    '74' => '074',
    '76' => '076',
    '77' => '077',
    '78' => '078',
    '79' => '079',
    '80' => '080',
    '81' => '081',
    '82' => '082',
    '83' => '083',
    '84' => '084',
    '86' => '086',
    '87' => '087',
    '88' => '088',
    '89' => '089',
    '91' => '091',
    '92' => '092',
    '94' => '094',
    '97' => '097',
    '98' => '098',
    '99' => '099',
    'A1' => '100',
    'A2' => '101',
    'A3' => '102',
    'A6' => '105',
    'A7' => '106',
    'A8' => '107',
    'B1' => '109',
    'B2' => '117',
    'B3' => '118',
    'B4' => '119',
    'B6' => '110',
    'B7' => '111',
    'B8' => '121',
    'B9' => '122',
    'C1' => '123',
    'C2' => '112',
    'C4' => '114',
    'C5' => '124',
    'C6' => '125',
    'C7' => '126',
    'C8' => '115',
    'C9' => '127',
    'D1' => '116',
    'D2' => '128',
    'D3' => '129',
    'D4' => '130',
    'D5' => '131',
    'D6' => '132',
    'D7' => '133',
    'D8' => '134',
    'E1' => '136',
    'E2' => '137',
    'E3' => '138',
    'E5' => '140',
    'E6' => '141',
    'E7' => '142',
    'E9' => '143',
    'F1' => '146',
    'F2' => '147',
    'F3' => '144',
    'F4' => '148',
    'F5' => '149',
    'F6' => '150',
    'F7' => '151',
    'F8' => '152',
    'F9' => '153',
    'G1' => '018',
    'G2' => '154',
    'G3' => '155',
    'G4' => '021',
    'G5' => '156',
    'G6' => '157',
    'G7' => '023',
    'G8' => '158',
    'G9' => '159',
    'H1' => '160',
    'H2' => '161',
    'H3' => '162',
    'H4' => '041',
    'H5' => '163',
    'H6' => '043',
    'H7' => '048',
    'H8' => '164',
    'H9' => '165',
    'I1' => '166',
    'I2' => '056',
    'I3' => '058',
    'I4' => '059',
    'I5' => '060',
    'I6' => '063',
    'I7' => '065',
    'I8' => '167',
    'I9' => '067',
    'J1' => '069',
    'J2' => '070',
    'J3' => '168',
    'J4' => '169',
    'J5' => '075',
    'J6' => '170',
    'J7' => '085',
    'J8' => '171',
    'J9' => '090',
    'K1' => '172',
    'K2' => '093',
    'K3' => '173',
    'K4' => '174',
    'K5' => '095',
    'K6' => '175',
    'K7' => '096',
    'K8' => '103',
    'K9' => '176',
    'L1' => '104',
    'L2' => '177',
    'L3' => '108',
    'L4' => '033',
    'L5' => '178',
    'L6' => '183',
    'L7' => '120',
    'L8' => '113',
    'L9' => '194',
    'M1' => '179',
    'M2' => '180',
    'M3' => '181',
    'M4' => '182',
    'M5' => '184',
    'M6' => '010',
    'M7' => '185',
    'M8' => '186',
    'M9' => '187',
    'N1' => '188',
    'N2' => '135',
    'N3' => '139',
    'N4' => '189',
    'N5' => '190',
    'N6' => '191',
    'N7' => '192',
    'N8' => '193',
    'N9' => '195',
    'O1' => '196',
    'O2' => '207',
    'O3' => '197',
    'O4' => '208',
    'O5' => '198',
    'O6' => '212',
    'O7' => '199',
    'O8' => '200',
    'O9' => '209',
    'P1' => '201',
    'P2' => '211',
    'P3' => '206',
    'P4' => '202',
    'P5' => '203',
    'P6' => '204',
    'P7' => '210',
    'P8' => '205',
    'P9' => '213',
  ],
  'SK' => [
    '01' => 'BC',
    '02' => 'BL',
    '03' => 'KI',
    '04' => 'NI',
    '05' => 'PV',
    '06' => 'TC',
    '07' => 'TA',
    '08' => 'ZI',
  ],
  'SL' => [
    '01' => 'E',
    '02' => 'N',
    '03' => 'S',
    '04' => 'W',
    '05' => 'NW',
  ],
  'SM' => [
    '01' => '01',
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
    '09' => '09',
  ],
  'SN' => [
    '01' => 'DK',
    '03' => 'DB',
    '05' => 'TC',
    '07' => 'TH',
    '09' => 'FK',
    '10' => 'KL',
    '11' => 'KD',
    '12' => 'ZG',
    '13' => 'LG',
    '14' => 'SL',
    '15' => 'MT',
    '16' => 'KA',
    '17' => 'KE',
    '18' => 'SE',
  ],
  'SO' => [
    '01' => 'BK',
    '02' => 'BN',
    '03' => 'BR',
    '04' => 'BY',
    '05' => 'GA',
    '06' => 'GE',
    '07' => 'HI',
    '08' => 'JD',
    '09' => 'JH',
    '10' => 'MU',
    '12' => 'SA',
    '13' => 'SD',
    '14' => 'SH',
    '18' => 'NU',
    '19' => 'TO',
    '20' => 'WO',
    '21' => 'AW',
    '22' => 'SO',
  ],
  'SR' => [
    '10' => 'BR',
    '11' => 'CM',
    '12' => 'CR',
    '13' => 'MA',
    '14' => 'NI',
    '15' => 'PR',
    '16' => 'PM',
    '17' => 'SA',
    '18' => 'SI',
    '19' => 'WA',
  ],
  'SS' => [
    '01' => 'EC',
    '02' => 'EE',
    '03' => 'JG',
    '04' => 'LK',
    '05' => 'BN',
    '06' => 'UY',
    '07' => 'NU',
    '08' => 'WR',
    '09' => 'BW',
    '10' => 'EW',
  ],
  'ST' => [
    '01' => 'P',
    '02' => 'S',
  ],
  'SV' => [
    '01' => 'AH',
    '02' => 'CA',
    '03' => 'CH',
    '04' => 'CU',
    '05' => 'LI',
    '06' => 'PA',
    '07' => 'UN',
    '08' => 'MO',
    '09' => 'SM',
    '10' => 'SS',
    '11' => 'SA',
    '12' => 'SV',
    '13' => 'SO',
    '14' => 'US',
  ],
  'SY' => [
    '01' => 'HA',
    '02' => 'LA',
    '03' => 'QU',
    '04' => 'RA',
    '05' => 'SU',
    '06' => 'DR',
    '07' => 'DY',
    '08' => 'RD',
    '09' => 'HL',
    '10' => 'HM',
    '11' => 'HI',
    '12' => 'ID',
    '13' => 'DI',
    '14' => 'TA',
  ],
  'SZ' => [
    '01' => 'HH',
    '02' => 'LU',
    '03' => 'MA',
    '04' => 'SH',
  ],
  'TD' => [
    '01' => 'BA',
    '02' => 'WF',
    '05' => 'GR',
    '06' => 'KA',
    '07' => 'LC',
    '08' => 'LO',
    '09' => 'LR',
    '12' => 'OD',
    '13' => 'SA',
    '14' => 'TA',
    '15' => 'CB',
    '16' => 'ME',
    '17' => 'MC',
    '18' => 'HL',
    '19' => 'MA',
    '20' => 'MO',
    '21' => 'ND',
    '22' => 'BG',
    '23' => 'BO',
    '24' => 'EN',
    '25' => 'SI',
    '26' => 'TI',
    '27' => 'EE',
    '28' => 'EO',
  ],
  'TG' => [
    '22' => 'C',
    '23' => 'K',
    '24' => 'M',
    '25' => 'P',
    '26' => 'S',
  ],
  'TH' => [
    '01' => '58',
    '02' => '50',
    '03' => '57',
    '04' => '55',
    '05' => '51',
    '06' => '52',
    '07' => '54',
    '08' => '63',
    '09' => '64',
    '10' => '53',
    '11' => '62',
    '12' => '65',
    '13' => '66',
    '14' => '67',
    '15' => '61',
    '16' => '60',
    '17' => '43',
    '18' => '42',
    '20' => '47',
    '22' => '40',
    '23' => '46',
    '24' => '44',
    '25' => '45',
    '26' => '36',
    '27' => '30',
    '28' => '31',
    '29' => '32',
    '30' => '33',
    '31' => '96',
    '32' => '18',
    '33' => '17',
    '34' => '16',
    '35' => '15',
    '36' => '14',
    '37' => '19',
    '38' => '12',
    '39' => '13',
    '40' => '10',
    '41' => '56',
    '42' => '11',
    '43' => '26',
    '44' => '24',
    '46' => '20',
    '47' => '21',
    '48' => '22',
    '49' => '23',
    '50' => '71',
    '51' => '72',
    '52' => '70',
    '53' => '73',
    '54' => '75',
    '55' => '74',
    '56' => '76',
    '57' => '77',
    '58' => '86',
    '59' => '85',
    '60' => '84',
    '61' => '82',
    '62' => '83',
    '63' => '81',
    '64' => '80',
    '65' => '92',
    '66' => '93',
    '67' => '91',
    '68' => '90',
    '69' => '94',
    '70' => '95',
    '72' => '35',
    '73' => '48',
    '74' => '25',
    '75' => '34',
    '76' => '41',
    '77' => '37',
    '78' => '49',
    '79' => '39',
    '80' => '27',
    '81' => '38',
  ],
  'TJ' => [
    '01' => 'GB',
    '02' => 'KT',
    '03' => 'SU',
    '04' => 'DU',
    '05' => 'RA',
  ],
  'TL' => [
    '01' => 'AL',
    '02' => 'AN',
    '03' => 'BA',
    '04' => 'BO',
    '05' => 'CO',
    '06' => 'DI',
    '07' => 'ER',
    '08' => 'LA',
    '09' => 'LI',
    '11' => 'MF',
    '10' => 'MT',
    '12' => 'OE',
    '13' => 'VI',
  ],
  'TM' => [
    '01' => 'A',
    '02' => 'B',
    '03' => 'D',
    '04' => 'L',
    '05' => 'M',
    '06' => 'S',
  ],
  'TN' => [
    '02' => '42',
    '03' => '41',
    '06' => '32',
    '14' => '33',
    '15' => '53',
    '16' => '52',
    '17' => '31',
    '18' => '23',
    '19' => '21',
    '22' => '34',
    '23' => '51',
    '27' => '13',
    '28' => '82',
    '29' => '81',
    '30' => '71',
    '31' => '73',
    '32' => '61',
    '33' => '43',
    '34' => '83',
    '35' => '72',
    '36' => '11',
    '37' => '22',
    '38' => '12',
    '39' => '14',
  ],
  'TO' => [
    '01' => '02',
    '02' => '04',
    '03' => '05',
    '04' => '01',
    '05' => '03',
  ],
  'TR' => [
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '07' => '07',
    '08' => '08',
    '09' => '09',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '19' => '19',
    '20' => '20',
    '21' => '21',
    '22' => '22',
    '23' => '23',
    '24' => '24',
    '25' => '25',
    '26' => '26',
    '28' => '28',
    '31' => '31',
    '32' => '33',
    '33' => '32',
    '34' => '34',
    '35' => '35',
    '37' => '37',
    '38' => '38',
    '39' => '39',
    '40' => '40',
    '41' => '41',
    '43' => '43',
    '44' => '44',
    '45' => '45',
    '46' => '46',
    '48' => '48',
    '49' => '49',
    '50' => '50',
    '52' => '52',
    '53' => '53',
    '54' => '54',
    '55' => '55',
    '57' => '57',
    '58' => '58',
    '59' => '59',
    '60' => '60',
    '61' => '61',
    '62' => '62',
    '63' => '63',
    '64' => '64',
    '65' => '65',
    '66' => '66',
    '68' => '06',
    '69' => '29',
    '70' => '30',
    '71' => '42',
    '72' => '47',
    '73' => '51',
    '74' => '56',
    '75' => '68',
    '76' => '72',
    '77' => '69',
    '78' => '70',
    '79' => '71',
    '80' => '73',
    '81' => '01',
    '82' => '18',
    '83' => '27',
    '84' => '36',
    '85' => '67',
    '86' => '75',
    '87' => '74',
    '88' => '76',
    '89' => '78',
    '90' => '79',
    '91' => '80',
    '92' => '77',
    '93' => '81',
  ],
  'TT' => [
    '01' => 'ARI',
    '16' => 'MRC',
    '05' => 'POS',
    '10' => 'SFO',
    '11' => 'TOB',
    '13' => 'CHA',
    '14' => 'CTT',
    '15' => 'DMN',
    '17' => 'PED',
    '19' => 'PRT',
    '18' => 'PTF',
    '21' => 'SGE',
    '22' => 'SIP',
    '20' => 'SJL',
    '23' => 'TUP',
  ],
  'TV' => [
    '01' => 'FUN',
    '04' => 'NIT',
    '06' => 'NKF',
    '07' => 'NKL',
    '03' => 'NMA',
    '02' => 'NMG',
    '05' => 'NUI',
    '08' => 'VAI',
  ],
  'TW' => [
    '20' => 'TXQ',
    '05' => 'CHA',
    '06' => 'CYI',
    '07' => 'CYQ',
    '08' => 'HSQ',
    '09' => 'HSZ',
    '10' => 'HUA',
    '26' => 'ILA',
    '12' => 'KEE',
    '02' => 'KHH',
    '13' => 'KIN',
    '14' => 'LIE',
    '15' => 'MIA',
    '16' => 'NAN',
    '17' => 'PEN',
    '18' => 'PIF',
    '25' => 'TAO',
    '21' => 'TNN',
    '03' => 'TPE',
    '23' => 'NWT',
    '24' => 'TTT',
    '19' => 'TXG',
    '27' => 'YUN',
  ],
  'TZ' => [
    '02' => '19',
    '03' => '03',
    '04' => '04',
    '05' => '08',
    '06' => '09',
    '07' => '12',
    '08' => '13',
    '09' => '14',
    '10' => '16',
    '11' => '17',
    '12' => '18',
    '13' => '06',
    '14' => '21',
    '15' => '22',
    '16' => '23',
    '17' => '24',
    '18' => '25',
    '19' => '05',
    '20' => '10',
    '21' => '11',
    '22' => '07',
    '23' => '02',
    '24' => '20',
    '25' => '15',
    '26' => '01',
    '27' => '26',
    '28' => '27',
    '29' => '28',
    '30' => '29',
    '31' => '30',
  ],
  'UA' => [
    '01' => '71',
    '02' => '74',
    '03' => '77',
    '04' => '12',
    '05' => '14',
    '06' => '26',
    '07' => '63',
    '08' => '65',
    '09' => '68',
    '10' => '35',
    '11' => '43',
    '12' => '30',
    '13' => '32',
    '14' => '09',
    '15' => '46',
    '16' => '48',
    '17' => '51',
    '18' => '53',
    '19' => '56',
    '20' => '40',
    '21' => '59',
    '22' => '61',
    '23' => '05',
    '24' => '07',
    '25' => '21',
    '26' => '23',
    '27' => '18',
  ],
  'UG' => [
    '99' => '302',
    '28' => '401',
    '29' => '402',
    'A2' => '304',
    '31' => '403',
    '33' => '204',
    '34' => '404',
    '36' => '101',
    '37' => '102',
    'A4' => '205',
    'A5' => '206',
    '40' => '406',
    '41' => '407',
    '42' => '103',
    '43' => '408',
    'A7' => '306',
    '46' => '208',
    'A8' => '307',
    '50' => '409',
    'B2' => '410',
    'B4' => '107',
    '58' => '310',
    '59' => '411',
    'B5' => '210',
    '61' => '110',
    '98' => '301',
    '66' => '201',
    '67' => '202',
    'A6' => '207',
    'A9' => '104',
    '71' => '105',
    'B3' => '309',
    '73' => '109',
    '74' => '111',
    '76' => '212',
    'A1' => '303',
    'A3' => '203',
    '79' => '405',
    '80' => '213',
    '81' => '413',
    '82' => '414',
    '83' => '112',
    '84' => '305',
    '85' => '415',
    '86' => '214',
    'B1' => '209',
    '88' => '308',
    '89' => '106',
    '90' => '108',
    '91' => '311',
    '92' => '312',
    '93' => '412',
    '94' => '215',
    '95' => '211',
    '96' => '113',
    '97' => '313',
    'B6' => '314',
    'B7' => '315',
    'B8' => '216',
    'B9' => '316',
    'C1' => '217',
    'C2' => '218',
    'C3' => '219',
    'C4' => '220',
    'C5' => '416',
    'C6' => '221',
    'C7' => '317',
    'C8' => '417',
    'C9' => '418',
    'D1' => '318',
    'D2' => '222',
    'D3' => '419',
    'D4' => '319',
    'D5' => '114',
    'D6' => '223',
    'D7' => '320',
    'D8' => '115',
    'D9' => '116',
    'E1' => '224',
    'E2' => '321',
    'E3' => '322',
    'E4' => '323',
    'E5' => '324',
    'E6' => '420',
    'E7' => '117',
    'E8' => '118',
    'E9' => '225',
    'F1' => '119',
    'F2' => '120',
    'F3' => '226',
    'F4' => '121',
    'F5' => '122',
    'F6' => '227',
    'F7' => '421',
    'F8' => '325',
    'F9' => '228',
    'G1' => '123',
    'G2' => '422',
    'G3' => '326',
    'G4' => '229',
    'G5' => '124',
    'G6' => '423',
    'G7' => '230',
    'G8' => '327',
    'G9' => '231',
    'H1' => '424',
    'H2' => '328',
    'H3' => '329',
    'H4' => '425',
    'H5' => '232',
    'H6' => '426',
    'H7' => '330',
    'H8' => '430',
    'H9' => '233',
    'I1' => '427',
    'I2' => '428',
    'I3' => '125',
    'I4' => '234',
    'I5' => '331',
    'I6' => '332',
    'I7' => '429',
    'I8' => '431',
  ],
  'UM' => [
    '50' => '81',
    '100' => '84',
    '150' => '86',
    '200' => '67',
    '250' => '89',
    '300' => '71',
    '350' => '76',
    '400' => '95',
    '450' => '79',
  ],
  'UY' => [
    '01' => 'AR',
    '02' => 'CA',
    '03' => 'CL',
    '04' => 'CO',
    '05' => 'DU',
    '06' => 'FS',
    '07' => 'FD',
    '08' => 'LA',
    '09' => 'MA',
    '10' => 'MO',
    '11' => 'PA',
    '12' => 'RN',
    '13' => 'RV',
    '14' => 'RO',
    '15' => 'SA',
    '16' => 'SJ',
    '17' => 'SO',
    '18' => 'TA',
    '19' => 'TT',
  ],
  'UZ' => [
    '01' => 'AN',
    '02' => 'BU',
    '03' => 'FA',
    '05' => 'XO',
    '06' => 'NG',
    '07' => 'NW',
    '08' => 'QA',
    '09' => 'QR',
    '10' => 'SA',
    '12' => 'SU',
    '13' => 'TK',
    '14' => 'TO',
    '15' => 'JI',
    '16' => 'SI',
  ],
  'VC' => [
    '01' => '01',
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
  ],
  'VE' => [
    '01' => 'Z',
    '02' => 'B',
    '03' => 'C',
    '04' => 'D',
    '05' => 'E',
    '06' => 'F',
    '07' => 'G',
    '08' => 'H',
    '09' => 'Y',
    '11' => 'I',
    '12' => 'J',
    '13' => 'K',
    '14' => 'L',
    '15' => 'M',
    '16' => 'N',
    '17' => 'O',
    '18' => 'P',
    '19' => 'R',
    '20' => 'S',
    '21' => 'T',
    '22' => 'U',
    '23' => 'V',
    '24' => 'W',
    '25' => 'A',
    '26' => 'X',
  ],
  'VI' => [
    '10' => 'C',
    '20' => 'J',
    '30' => 'T',
  ],
  'VN' => [
    '01' => '44',
    '03' => '50',
    '05' => '04',
    '09' => '45',
    '13' => 'HP',
    '20' => 'SG',
    '21' => '47',
    '23' => '35',
    '24' => '41',
    '30' => '13',
    '32' => '05',
    '33' => '37',
    '34' => '21',
    '35' => '20',
    '37' => '46',
    '39' => '09',
    '43' => '39',
    '44' => 'HN',
    '45' => '43',
    '46' => '31',
    '47' => '40',
    '49' => '30',
    '50' => '03',
    '51' => '15',
    '52' => '23',
    '53' => '14',
    '54' => '34',
    '55' => '28',
    '58' => '22',
    '59' => '18',
    '60' => '36',
    '61' => '32',
    '62' => '24',
    '63' => '29',
    '64' => '25',
    '65' => '52',
    '66' => '26',
    '67' => '51',
    '68' => '07',
    '69' => '49',
    '70' => '06',
    '71' => '54',
    '72' => '53',
    '73' => '55',
    '74' => '56',
    '75' => '57',
    '76' => '58',
    '77' => '59',
    '78' => 'DN',
    '79' => '61',
    '80' => '63',
    '81' => '66',
    '82' => '67',
    '83' => '68',
    '84' => '27',
    '85' => '69',
    '86' => '70',
    '87' => 'CT',
    '88' => '33',
    '89' => '01',
    '90' => '02',
    '91' => '72',
    '92' => '71',
    '93' => '73',
  ],
  'VU' => [
    '07' => 'TOB',
    '13' => 'SAM',
    '15' => 'TAE',
    '16' => 'MAP',
    '17' => 'PAM',
    '18' => 'SEE',
  ],
  'WF' => [
    '01' => 'AL',
    '02' => 'SG',
    '03' => 'UV',
  ],
  'WS' => [
    '01' => 'AA',
    '02' => 'AL',
    '03' => 'AT',
    '04' => 'FA',
    '05' => 'GE',
    '06' => 'VF',
    '07' => 'GI',
    '08' => 'PA',
    '09' => 'SA',
    '10' => 'TU',
    '11' => 'VS',
  ],
  'YE' => [
    '01' => 'AB',
    '02' => 'AD',
    '03' => 'MR',
    '04' => 'HD',
    '05' => 'SH',
    '08' => 'HU',
    '10' => 'MW',
    '11' => 'DH',
    '14' => 'MA',
    '15' => 'SD',
    '16' => 'SN',
    '18' => 'DA',
    '19' => 'AM',
    '20' => 'BA',
    '21' => 'JA',
    '22' => 'HJ',
    '23' => 'IB',
    '24' => 'LA',
    '25' => 'TA',
    '26' => 'SA',
    '27' => 'RA',
    '28' => 'SU',
  ],
  'ZA' => [
    '02' => 'KZN',
    '03' => 'FS',
    '05' => 'EC',
    '06' => 'GP',
    '07' => 'MP',
    '08' => 'NC',
    '09' => 'LP',
    '10' => 'NW',
    '11' => 'WC',
  ],
  'ZM' => [
    '01' => '01',
    '02' => '02',
    '03' => '03',
    '04' => '04',
    '05' => '05',
    '06' => '06',
    '07' => '07',
    '08' => '08',
    '09' => '09',
    '10' => '10',
  ],
  'ZW' => [
    '01' => 'MA',
    '02' => 'MI',
    '03' => 'MC',
    '04' => 'ME',
    '05' => 'MW',
    '06' => 'MN',
    '07' => 'MS',
    '08' => 'MV',
    '09' => 'BU',
    '10' => 'HA',
  ],
];
