<?php
/**
 * @file classes/components/form/context/PKPSearchIndexingForm.php
 *
 * Copyright (c) 2014-2021 Simon Fraser University
 * Copyright (c) 2000-2021 John Willinsky
 * Distributed under the GNU GPL v3. For full terms see the file docs/COPYING.
 *
 * @class PKPSearchIndexingForm
 *
 * @ingroup classes_controllers_form
 *
 * @brief A preset form for configuring a context's search indexing settings.
 */

namespace PKP\components\forms\context;

use PKP\components\forms\FieldText;
use PKP\components\forms\FieldTextarea;
use PKP\components\forms\FormComponent;

define('FORM_SEARCH_INDEXING', 'searchIndexing');

class PKPSearchIndexingForm extends FormComponent
{
    /** @copydoc FormComponent::$id */
    public $id = FORM_SEARCH_INDEXING;

    /** @copydoc FormComponent::$method */
    public $method = 'PUT';

    /**
     * Constructor
     *
     * @param string $action URL to submit the form to
     * @param array $locales Supported locales
     * @param \PKP\context\Context $context Journal or Press to change settings for
     * @param string $sitemapUrl A URL to the context's sitemap for use in the
     *  search engine indexing group description
     */
    public function __construct($action, $locales, $context, $sitemapUrl)
    {
        $this->action = $action;
        $this->locales = $locales;

        $this->addGroup([
            'id' => 'search',
            'label' => __('manager.setup.searchEngineIndexing'),
            'description' => __('manager.setup.searchEngineIndexing.description', ['sitemapUrl' => $sitemapUrl]),
        ])
            ->addField(new FieldText('searchDescription', [
                'label' => __('common.description'),
                'tooltip' => __('manager.setup.searchDescription.description'),
                'isMultilingual' => true,
                'value' => $context->getData('searchDescription'),
                'groupId' => 'search',
            ]))
            ->addField(new FieldTextArea('customHeaders', [
                'label' => __('manager.distribution.customHeaders'),
                'tooltip' => __('manager.distribution.customHeaders.description'),
                'isMultilingual' => true,
                'value' => $context->getData('customHeaders'),
                'groupId' => 'search',
            ]));
    }
}
