# Authoring

1. Introduction
2. [Make a Submission](authoring#make-submission)
3. [Track your Submission](authoring#track-submission)

This chapter will help authors make a new submission and participate in the editorial workflow as it is reviewed, edited and eventually published.

Before you can begin a new submission, you'll need to register for a user account with the site and login.

## <a name="make-submission"></a>Make a Submission

To start a new submission, click the **Submission** link from the left-hand navigation menu and then click the **New Submission** button on the right.

*If you're logged in, but you don't see the editorial interface, you may be viewing the reader-facing website. If that's the case, find your user profile link and click on the Submissions link which appears below it. Each website may be different.*

Making a new submission is an easy-to-follow 5-step process. Follow along with the on-screen instructions to complete the process.

### <a name="prepare"></a>Prepare

Provide initial information and confirm that you've followed the requirements before beginning your submission.

### <a name="upload"></a>Upload

You can upload one or more files with your submission. Select multiple files to upload more than one file at a time or upload each file individually.

Each file needs to be identified as a particular component type. The type options will vary depending on what has been defined by the journal, but they could include article text, data sets, research results, or images.

Select Save and Continue to move to the next step.

### <a name="catalog"></a>Catalog

Add your submission details, such as title and abstract. You'll also have an opportunity to define chapters for your book and, if there are multiple authors, add contributors.

If you're submitting an edited volume with different authors for each chapter, you can associate contributors with each chapter from the chapter editing screen.

### <a name="confirmation"></a>Confirmation

Take a moment to confirm the details you've entered. At this point, you can jump back to any of the previous steps to change the details you've entered.

### <a name="next-steps"></a>Next Steps

You've done it! If you want to read more about tracking your submission, read the next section.

## <a name="track-submission"></a>Track your Submission

When your submission is under consideration, you can keep an eye on it's status by logging into the website and going to the [Submissions](submissions) page.

Here you'll find you submissions listed with the current stage of the editorial workflow it is in. Click the stage name to interact with that stage.

### <a name="track-submission-discussions"></a>Discussion Panels

In each stage you'll have access to a discussion area. If an editor or editorial assistant needs more information from you, they'll be able to open a discussion. When that happens, you'll be notified by email so that you can respond.

*You won't be able to initiate discussions on most stages, but they'll appear if one has been initiated by the editors.*

### <a name="track-submission-review"></a>Review Stages

During the review stages, you'll see a status update at the top, which will keep you informed as reviewers are recruited, assigned and submit their reviews.

Dyring the review stages, you may be asked to submit revisions which address any concerns raised. If needed, you'll find a Revisions panel where you can upload new files for the editor.
