# Settings

1. Introduction
2. [Press](settings#context)
3. [Website](settings#website)
4. [Workflow](settings#workflow)
5. [Distribution](settings#distribution)

Configure your website to suit your needs from the collection of Settings pages provided by OMP.

You can access the Settings pages by clicking on the **Settings** link in the main navigation menu on the left, then selecting the specific settings page you'd like.

*Only Journal Managers and Administrators can access and edit the settings.*

There's a lot to be uncovered here. While we're improving this documentation, we've provided a quick overview of what each settings page is for, and detailed break-outs for the trickiest options.

## <a name="context"></a>Press

Configure basic details about the press, including contact information, policies, author guidelines, sponsor relationships and more. You can also add Series and Categories to your catalog from this settings page.

## <a name="website"></a>Website

Configure the appearance of your reader-facing website, including logo upload, homepage configuration, sidebar management and more.

You can also set up your site's languages, install and enable plugins, send out announcements and draft key information blocks for visitors.

## <a name="workflow"></a>Workflow

Configure all aspects of the [Editorial Workflow](editorial-workflow), including file management, submission guidelines and requirements, peer review deadlines and guidelines, email notifications and much more.

## <a name="workflow-submission"></a>Submission

Set submission requirements, provide author guidelines, configure your submission file types and more.

### <a name="workflow-submission-metadata"></a>Metadata

Decide which types of metadata, such as keywords and references, your press will support.

You can also determine whether or not the author should be required to provide each type of metadata during submission, or whether this information should be added by editors.

### <a name="workflow-submission-components"></a>Components

Your publication files may consist of a number of components, including a book-length manuscript or a chapter-length manuscript, as well as illustrations, glossary, index and more.

When authors and editors upload files to a submission, they will be asked to identify the component of this file.

The Components tab provides a list of common components by default. You are encouraged to add or edit components to suit the particular needs of your press.

Delete those that aren't appropriate for your press. This will reduce the options faced by authors struggling through their first submission.

### <a name="workflow-submission-checklist"></a>Checklist

Provide authors with a checklist of tasks they should complete before making their submission. This is a good place to indicate requirements for referencing, font size, line spacing, document format and more.

### <a name="workflow-submission-guidelines"></a>Author Guidelines

Provde any additional guidelines that are not adequately covered in the submission checklist and provide a copyright statement to inform submitting authors of their rights.

## <a name="workflow-review"></a>Review

Set all of your review policies and procedures, including deadlines, notifications, reviewer guidelines and more.

### <a name="workflow-review-mode"></a>Default Review Mode

Choose the review mode that should be used by default.

- A **Double-Blind** review will prevent the reviewer and the author from knowing each other's identities.
- A **Blind** review will prevent the author from knowing the reviewer's identity.
- An **Open** review will allow the reviewer and author to know each other's identities.

An editor will be able to choose another type when needed, but will usually use the default.

### <a name="workflow-review-file-access"></a>Restrict File Access

By default, a reviewer will be able to view submission files before deciding whether or not to review it. Check this box if you would like them to accept a review assignment before viewing the files.

### <a name="workflow-review-guidelines"></a>Internal and External Review Guidelines

Provide reviewers with criteria for judging a submission's suitability for publication in the journal, which may include instructions for preparing an effective and helpful review. Reviewers will have an opportunity to provide comments intended for the author and editor, as well as separate comments only for the editor.

Many presses prefer to pass a submission through an internal review before being sent for external review. You may tailor your instructions to each group of reviewers.

### <a name="workflow-review-interests"></a>Competing Interests

Reviewers will be asked to confirm that they comply with the competing interests disclosure policy you specify below.

### <a name="workflow-review-forms"></a>Review Forms

If you'd like to request specific information from reviewers, you can build forms here. An editor will be able to select a form when assigning a reviewer, and the reviewer will be asked to complete that form when they are submitting their review.

### <a name="workflow-library"></a>Press Library

The Press Library provides a file repository for storing and quickly sharing common files, such as writing guidelines, author contracts and release forms, and marketing materials.

Items that are stored in the Press Library can be quickly retrieved and added into a [Submission Library](editorial-workflow#submission-library) to be shared with authors or assistants.

### <a name="workflow-emails"></a>Emails

OMP sends a number of emails during various stages of the [Editorial Workflow](editorial-workflow), as well as other actions such as registration and submission acknowledgement.

The settings in this section allow you to tailor the common header and signature that accompany those emails, as well as update the email defaults for each type of email that's sent out.

You can view more about one of the emails in the list by clicking the dropdown arrow on the right.

*If you want to restore an email template to it's default, use the __Reset__ button to restore the default message. This button is only available for email templates that have been modified.*

## <a name="distribution"></a>Distribution

Configure settings related to your search engine indexing, any payments if you're taking them, and permissions and licensing details for publications.

In the Permissions tab, you'll find settings for asserting copyright and author licensing.

### <a name="copyright-v-license"></a> What's the difference between Copyright and a License?

The copyright identifies the author or owner of copyright for a published work. For example, Copyright (c) 2016 by Jane Smith.

The license attached to a work will determine the usage rights for the published work. For example, CC-By 4.0 allows the work to be copied, redistributed and adapted for any purpose, even commercially, as long as attribution is given to the copyright holder.
