JATS Template Plugin
====================

This plugin permits OJS to use a basic JATS XML document generated from the OJS
metadata and full-text extraction in cases where a better JATS XML document is
not available.

It is intended to be used in concert with the OAI JATS plugin (available at
https://github.com/pkp/oaiJats) to deliver JATS via OAI for journals that do
not have better JATS XML available.

Note that the JATS XML this plugin delivers it not intended for publication
i.e. using Lens Reader -- considerable additional improvement and quality
control would be required before the document is suitable for that purpose.

| Tag                                                                                                            | Definition                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | Support | Unit-tests |
|----------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------|------------|
| [journal-id](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/journal-id.html)                     | Short code or abbreviation used as an identifier for a journal.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | :ok:    | :ok:       |
| [journal-title-group](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/journal-title-group.html)   | Container element for the titles of the journal in which the article was published.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | :ok:    | :ok:       |
| [journal-title](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/journal-title.html)               | Full title of the journal in which the article was published.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | :ok:    | :ok:       |
| [trans-title-group](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/trans-title-group.html)       | Container element for translated and transliterated titles.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | :ok:    | :ok:       |
| [trans-title](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/trans-title.html)                   | Title of a document or document part that has been translated into a language other than that of the original publication. When a document is published simultaneously in more than one language, one language must be chosen for the title and all other document titles become translated titles.                                                                                                                                                                                                                                                                                                        | :ok:    | :ok:       |
| [abbrev-journal-title](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/abbrev-journal-title.html) | Short form of the title of the journal in which an article is published.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | :ok:    | :ok:       |
| [publisher](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/publisher.html)                       | Container element for information about the person, company, or other entity that published a work.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | :ok:    | :ok:       |
| [publisher-name](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/publisher-name.html)             | Name of the person, company, or other entity that published a work.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | :ok:    | :ok:       |
| [issn](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/issn.html)                                 | International Standard Serial Number, the international code that uniquely identifies a serial publication title.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | :ok:    | :ok:       |
| [article-meta](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/article-meta.html)                 | Container element for information concerning the article that identifies or describes the article.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | :ok:    | :ok:       |
| [article-id](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/article-id.html)                     | Unique external identifier assigned to an article.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | :ok:    | :ok:       |
| [article-categories](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/article-categories.html)     | Container element for elements that may be used to group articles into related clusters, for example, by subject matter or by series.                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | :ok:    | :ok:       |
| [subj-group](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/subj-group.html)                     | Container element for the subject matter designations describing a document’s content or a component document’s content. Subjects are used to organize documents into groupings (potentially hierarchical groupings) for display or print.                                                                                                                                                                                                                                                                                                                                                                 | :ok:    | :ok:       |
| [subject](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/subject.html)                           | Name of one subject or topic used to describe an article. Such topics and groupings of topics are typically used to provide headings for groups of documents or document components in a printed, or online, generated Table of Contents.                                                                                                                                                                                                                                                                                                                                                                  | :ok:    | :ok:       |
| [title-group](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/title-group.html)                   | Container element to hold the various titles for a document or a document component.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | :ok:    | :ok:       |
| [article-title](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/article-title.html)               | Full title of an article.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | :ok:    | :ok:       |
| [contrib-group](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/contrib-group.html)               | Container element for one or more contributors and information about those contributors.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | :ok:    | :ok:       |
| [contrib](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/contrib.html)                           | Container element for information about a single author, editor, or other contributor.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | :ok:    | :ok:       |
| [email](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/email.html)                               | Electronic mail address of a person or institution.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | :ok:    | :ok:       |
| [xref](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/xref.html)                                 | Reference to an object within the document (for example, a table, a bibliographic citation).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | :ok:    | :ok:       |
| [name](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/name.html)                                 | Container element for the component elements of personal names                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | :ok:    | :ok:       |
| [surname](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/surname.html)                           | Surname of a person.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | :ok:    | :ok:       |
| [given-names](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/given-names.html)                   | All given names of a person, such as the first name, middle names, maiden name if used as part of the married name, etc.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | :ok:    | :ok:       |
| [aff](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/aff.html)                                   | Name of an institution or organization (for example, university, corporation) with which a contributor is affiliated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | :ok:    | :ok:       |
| [institution](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/institution.html)                   | Name of an institution or organization (for example, a university or corporation).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | :ok:    | :ok:       |
| [fpage](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/fpage.html)                               | Page number on which a document starts.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | :ok:    | :ok:       |
| [lpage](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/lpage.html)                               | Page number on which a document ends.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | :ok:    | :ok:       |
| [permissions](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/permissions.html)                   | Container element for copyright and license information for the entire article or for the object which contains the <permissions> element.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | :ok:    | :ok:       |
| [copyright-statement](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/copyright-statement.html)   | Copyright notice or statement, suitable for printing or display.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | :ok:    | :ok:       |
| [copyright-year](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/copyright-year.html)             | The year of copyright.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | :ok:    | :ok:       |
| [copyright-holder](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/copyright-holder.html)         | Name of the organizational or personal entity that holds a copyright.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | :ok:    | :ok:       |
| [self-uri](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/self-uri.html)                         | URI for another version of a document. This element may be used when the document is available in multiple forms (for example, printed article and in its expanded version with additional graphics available online).                                                                                                                                                                                                                                                                                                                                                                                     | :ok:    | :ok:       |
| [kwd-group](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/kwd-group.html)                       | Container element for one set of keywords (such as <kwd>s, <nested-kwd>s, or <compound-kwd>s) used to describe a document.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | :ok:    | :ok:       |
| [kwd](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/kwd.html)                                   | A keyword is a finding aid used to record one subject term, key phrase, abbreviation, indexing word, taxonomic structure, or other expression that is associated with a whole structure (such as an article). Keywords can be used for identification, searching, and indexing purposes. A keyword element (<kwd>) may contain a repetition of words found in the structure, or it may contain broader terms, narrower terms, related terms, or taxonomic identifiers used to find the structure in a search or provide semantic classification of the text by mapping a specific structure to a taxonomy. | :ok:    | :ok:       |
| [counts](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/article-title.html)                      | Container element for counts of a document (for example, number of tables, number of figures, number of words).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | :ok:    | :ok:       |
| [page-count](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/page-count.html)                     | Total number of pages in a work in print; by convention, each page or partial page is counted as one. Electronic-only works do not traditionally have page counts.                                                                                                                                                                                                                                                                                                                                                                                                                                         | :ok:    | :ok:       |
| [body](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/body.html)                                 | Main textual portion of the document that conveys the narrative content.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | :ok:    | :ok:       |
| [p](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/p.html)                                       | Textual unit or block; a textual paragraph.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | :ok:    | :x:        |
| [back](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/back.html)                                 | Material published with an article but following the narrative flow.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | :ok:    | :ok:       |
| [ref-list](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/ref-list.html)                         | List of bibliographic references for a document or document component.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | :ok:    | :x:        |
| [ref](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/ref.html)                                   | One item in a bibliographic list.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | :ok:    | :x:        |
| [mixed-citation](https://jats.nlm.nih.gov/archiving/tag-library/1.3d1/element/mixed-citation.html)             | Bibliographic description of a work. Includes a combination of bibliographic reference elements and untagged text. Spacing and punctuation are preserved.                                                                                                                                                                                                                                                                                                                                                                                                                                                  | :ok:    | :x:        |

## Installation

This plugin should be available from the Plugin Gallery within OJS.

## Automated Tests

```
./lib/pkp/lib/vendor/bin/phpunit ./plugins/generic/jatsTemplate/tests/functional/ArticleTest.php --configuration lib/pkp/tests/phpunit.xml
./lib/pkp/lib/vendor/bin/phpunit ./plugins/generic/jatsTemplate/tests/functional/ArticleFrontTest.php --configuration lib/pkp/tests/phpunit.xml
./lib/pkp/lib/vendor/bin/phpunit ./plugins/generic/jatsTemplate/tests/functional/ArticleBackTest.php --configuration lib/pkp/tests/phpunit.xml
./lib/pkp/lib/vendor/bin/phpunit ./plugins/generic/jatsTemplate/tests/functional/ArticleBodyTest.php --configuration lib/pkp/tests/phpunit.xml
```
